/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support.resume;

import java.util.Collection;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.consumer.CommitManager;
import org.apache.camel.component.kafka.consumer.support.resume.KafkaResumeAdapter;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumeRebalanceListener
implements ConsumerRebalanceListener {
    private static final Logger LOG = LoggerFactory.getLogger(ResumeRebalanceListener.class);
    private final String threadId;
    private final KafkaConfiguration configuration;
    private final CommitManager commitManager;
    private final KafkaResumeAdapter resumeAdapter;

    public ResumeRebalanceListener(String threadId, KafkaConfiguration configuration, CommitManager commitManager, Consumer<?, ?> consumer, ResumeStrategy resumeStrategy) {
        this.threadId = threadId;
        this.configuration = configuration;
        this.commitManager = commitManager;
        this.resumeAdapter = (KafkaResumeAdapter)resumeStrategy.getAdapter(KafkaResumeAdapter.class);
        this.resumeAdapter.setConsumer(consumer);
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        for (TopicPartition partition : partitions) {
            LOG.debug("onPartitionsRevoked: {} from {}", (Object)this.threadId, (Object)partition.topic());
            if (this.configuration.getAutoCommitEnable()) continue;
            this.commitManager.commit(partition);
        }
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        if (LOG.isDebugEnabled()) {
            partitions.forEach(p -> LOG.debug("onPartitionsAssigned: {} from {}", (Object)this.threadId, (Object)p.topic()));
        }
        this.resumeAdapter.resume();
    }
}

