/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.download.DownloadListener;
import org.apache.camel.spi.Language;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConfigureDownloadListener
implements DownloadListener,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(AutoConfigureDownloadListener.class);
    private CamelContext camelContext;
    private final Set<String> artifacts = new HashSet<String>();

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void onDownloadDependency(String groupId, String artifactId, String version) {
    }

    @Override
    public void onDownloadedDependency(String groupId, String artifactId, String version) {
        if (!this.artifacts.contains(artifactId)) {
            this.artifacts.add(artifactId);
            this.autoConfigureDependencies(artifactId);
            this.autoConfigure(artifactId);
        }
    }

    @Override
    public void onAlreadyDownloadedDependency(String groupId, String artifactId, String version) {
    }

    protected void autoConfigureDependencies(String artifactId) {
        InputStream is = this.getClass().getResourceAsStream("/auto-configure/" + artifactId + ".properties");
        if (is != null) {
            try {
                String script = IOHelper.loadText((InputStream)is);
                for (String line : script.split("\n")) {
                    if (!(line = line.trim()).startsWith("dependency=")) continue;
                    MavenGav gav = MavenGav.parseGav((String)line.substring(11));
                    DependencyDownloader downloader = (DependencyDownloader)this.getCamelContext().hasService(DependencyDownloader.class);
                    downloader.downloadHiddenDependency(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
    }

    protected void autoConfigure(String artifactId) {
        InputStream is = this.getClass().getResourceAsStream("/auto-configure/" + artifactId + ".joor");
        if (is != null) {
            try {
                DependencyDownloader downloader = (DependencyDownloader)this.getCamelContext().hasService(DependencyDownloader.class);
                downloader.downloadHiddenDependency("org.apache.camel", "camel-joor", this.camelContext.getVersion());
                String script = IOHelper.loadText((InputStream)is);
                Language lan = this.camelContext.resolveLanguage("joor");
                Expression exp = lan.createExpression(script);
                Object out = exp.evaluate((Exchange)new DefaultExchange(this.camelContext), Object.class);
                if (ObjectHelper.isNotEmpty((Object)out)) {
                    LOG.info("{}", out);
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
    }
}

