/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.impl.engine.DefaultDataFormatResolver;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.util.SuggestSimilarHelper;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.tooling.model.DataFormatModel;

public final class DependencyDownloaderDataFormatResolver
extends DefaultDataFormatResolver {
    private final CamelCatalog catalog = new DefaultCamelCatalog();
    private final CamelContext camelContext;
    private final DependencyDownloader downloader;

    public DependencyDownloaderDataFormatResolver(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
    }

    public DataFormat createDataFormat(String name, CamelContext context) {
        List<String> suggestion;
        DataFormat answer;
        DataFormatModel model = this.catalog.dataFormatModel(name);
        if (model != null && !this.downloader.alreadyOnClasspath(model.getGroupId(), model.getArtifactId(), model.getVersion())) {
            this.downloader.downloadDependency(model.getGroupId(), model.getArtifactId(), model.getVersion());
        }
        if ((answer = super.createDataFormat(name, context)) == null && (suggestion = SuggestSimilarHelper.didYouMean(this.catalog.findDataFormatNames(), name)) != null && !suggestion.isEmpty()) {
            String s = String.join((CharSequence)", ", suggestion);
            throw new IllegalArgumentException("Cannot find dataformat with name: " + name + ". Did you mean: " + s);
        }
        return answer;
    }
}

