/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import org.apache.camel.Component;
import org.apache.camel.component.stub.StubComponent;
import org.apache.camel.spi.Injector;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.ObjectHelper;

public class KameletMainInjector
implements Injector {
    private static final String ACCEPTED_STUB_NAMES = "StubComponent,BeanComponent,ClassComponent,DirectComponent,KameletComponent,LogComponent,RestComponent,RestApiComponent,PlatformHttpComponent,SedaComponent,VertxHttpComponent";
    private final Injector delegate;
    private final String stubPattern;
    private final boolean silent;

    public KameletMainInjector(Injector delegate, String stubPattern, boolean silent) {
        this.delegate = delegate;
        this.stubPattern = stubPattern;
        this.silent = silent;
    }

    public <T> T newInstance(Class<T> type) {
        boolean accept = this.acceptComponent(type);
        if (!accept) {
            return (T)this.delegate.newInstance(StubComponent.class);
        }
        return (T)this.delegate.newInstance(type);
    }

    public <T> T newInstance(Class<T> type, String factoryMethod) {
        boolean accept = this.acceptComponent(type);
        if (!accept) {
            return (T)this.delegate.newInstance(StubComponent.class);
        }
        return (T)this.delegate.newInstance(type, factoryMethod);
    }

    public <T> T newInstance(Class<T> type, Class<?> factoryClass, String factoryMethod) {
        boolean accept = this.acceptComponent(type);
        if (!accept) {
            return (T)this.delegate.newInstance(StubComponent.class);
        }
        return (T)this.delegate.newInstance(type, factoryClass, factoryMethod);
    }

    public <T> T newInstance(Class<T> type, boolean postProcessBean) {
        boolean accept = this.acceptComponent(type);
        if (!accept) {
            return (T)this.delegate.newInstance(StubComponent.class);
        }
        return (T)this.delegate.newInstance(type, postProcessBean);
    }

    public boolean supportsAutoWiring() {
        return this.delegate.supportsAutoWiring();
    }

    private boolean acceptComponent(Class<?> type) {
        org.apache.camel.spi.annotations.Component ann;
        boolean accept = true;
        if (this.stubPattern != null && Component.class.isAssignableFrom(type) && !(accept = this.accept(type)) && !"*".equals(this.stubPattern) && (ann = (org.apache.camel.spi.annotations.Component)ObjectHelper.getAnnotation((Object)this, org.apache.camel.spi.annotations.Component.class)) != null) {
            boolean found = false;
            String name = ann.value();
            for (String n : name.split(",")) {
                if (!PatternHelper.matchPattern((String)n, (String)this.stubPattern)) continue;
                found = true;
                break;
            }
            accept = !found;
        }
        return accept;
    }

    private boolean accept(Class<?> type) {
        String shortName = type.getSimpleName();
        return ACCEPTED_STUB_NAMES.contains(shortName);
    }
}

