/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dsl.yaml.KameletRoutesBuilderLoader;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.main.util.SuggestSimilarHelper;
import org.apache.camel.main.util.VersionHelper;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ReflectionHelper;

public class KnownKameletRoutesBuilderLoader
extends KameletRoutesBuilderLoader {
    private String kameletsVersion;

    public KnownKameletRoutesBuilderLoader(String kameletsVersion) {
        this.kameletsVersion = kameletsVersion;
    }

    public RouteBuilder doLoadRouteBuilder(Resource resource) throws Exception {
        if (!resource.exists()) {
            String loc = resource.getLocation();
            String name = FileUtil.onlyName((String)loc, (boolean)false);
            List<String> suggestion = SuggestSimilarHelper.didYouMean(this.findKameletNames(), name);
            if (suggestion != null && !suggestion.isEmpty()) {
                String s = String.join((CharSequence)", ", suggestion);
                throw new IllegalArgumentException("Cannot find Kamelet with name: " + name + ". Did you mean: " + s);
            }
        }
        return super.doLoadRouteBuilder(resource);
    }

    private List<String> findKameletNames() {
        if (this.kameletsVersion == null) {
            this.kameletsVersion = VersionHelper.extractKameletsVersion();
        }
        try {
            Class clazz;
            MavenDependencyDownloader downloader = (MavenDependencyDownloader)this.getCamelContext().hasService(MavenDependencyDownloader.class);
            if (!downloader.alreadyOnClasspath("org.apache.camel.kamelets", "camel-kamelets-catalog", this.kameletsVersion)) {
                downloader.downloadDependency("org.apache.camel.kamelets", "camel-kamelets-catalog", this.kameletsVersion);
            }
            if ((clazz = this.getCamelContext().getClassResolver().resolveClass("org.apache.camel.kamelets.catalog.KameletsCatalog")) != null) {
                Object catalog = this.getCamelContext().getInjector().newInstance(clazz);
                Method m = ReflectionHelper.findMethod((Class)clazz, (String)"getKameletsName", (Class[])new Class[0]);
                return (List)ObjectHelper.invokeMethod((Method)m, (Object)catalog, (Object[])new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }
}

