/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ShutdownableService;
import org.apache.camel.main.download.ArtifactDownloadListener;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.DownloadException;
import org.apache.camel.main.download.DownloadListener;
import org.apache.camel.main.download.DownloadRecord;
import org.apache.camel.main.download.DownloadThreadPool;
import org.apache.camel.main.download.KnownReposResolver;
import org.apache.camel.main.util.VersionHelper;
import org.apache.camel.main.util.XmlHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.tooling.maven.MavenArtifact;
import org.apache.camel.tooling.maven.MavenDownloader;
import org.apache.camel.tooling.maven.MavenDownloaderImpl;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.tooling.maven.MavenResolutionException;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MavenDependencyDownloader
extends ServiceSupport
implements DependencyDownloader {
    private static final String MINIMUM_QUARKUS_VERSION = "2.0.0";
    private static final Logger LOG = LoggerFactory.getLogger(MavenDependencyDownloader.class);
    private static final String CP = System.getProperty("java.class.path");
    private String[] bootClasspath;
    private DownloadThreadPool threadPool;
    private boolean verbose;
    private ClassLoader classLoader;
    private CamelContext camelContext;
    private final Set<DownloadListener> downloadListeners = new LinkedHashSet<DownloadListener>();
    private final Set<ArtifactDownloadListener> artifactDownloadListeners = new LinkedHashSet<ArtifactDownloadListener>();
    private final Map<String, DownloadRecord> downloadRecords = new HashMap<String, DownloadRecord>();
    private KnownReposResolver knownReposResolver;
    private MavenDownloader mavenDownloader;
    private String repos;
    private boolean fresh;
    private String mavenSettings;
    private String mavenSettingsSecurity;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public KnownReposResolver getKnownReposResolver() {
        return this.knownReposResolver;
    }

    public void setKnownReposResolver(KnownReposResolver knownReposResolver) {
        this.knownReposResolver = knownReposResolver;
    }

    @Override
    public void addDownloadListener(DownloadListener downloadListener) {
        CamelContextAware.trySetCamelContext((Object)downloadListener, (CamelContext)this.getCamelContext());
        this.downloadListeners.add(downloadListener);
    }

    @Override
    public void addArtifactDownloadListener(ArtifactDownloadListener downloadListener) {
        CamelContextAware.trySetCamelContext((Object)downloadListener, (CamelContext)this.getCamelContext());
        this.artifactDownloadListeners.add(downloadListener);
    }

    @Override
    public String getRepos() {
        return this.repos;
    }

    @Override
    public void setRepos(String repos) {
        this.repos = repos;
    }

    @Override
    public boolean isFresh() {
        return this.fresh;
    }

    @Override
    public void setFresh(boolean fresh) {
        this.fresh = fresh;
    }

    @Override
    public String getMavenSettings() {
        return this.mavenSettings;
    }

    @Override
    public void setMavenSettings(String mavenSettings) {
        this.mavenSettings = mavenSettings;
    }

    @Override
    public String getMavenSettingsSecurity() {
        return this.mavenSettingsSecurity;
    }

    @Override
    public void setMavenSettingsSecurity(String mavenSettingsSecurity) {
        this.mavenSettingsSecurity = mavenSettingsSecurity;
    }

    @Override
    public void downloadDependency(String groupId, String artifactId, String version) {
        this.downloadDependency(groupId, artifactId, version, true);
    }

    @Override
    public void downloadDependency(String groupId, String artifactId, String version, String extraRepos) {
        this.doDownloadDependency(groupId, artifactId, version, true, false, extraRepos);
    }

    @Override
    public void downloadHiddenDependency(String groupId, String artifactId, String version) {
        this.doDownloadDependency(groupId, artifactId, version, true, true, null);
    }

    @Override
    public void downloadDependency(String groupId, String artifactId, String version, boolean transitively) {
        this.doDownloadDependency(groupId, artifactId, version, transitively, false, null);
    }

    protected void doDownloadDependency(String groupId, String artifactId, String version, boolean transitively, boolean hidden, String extraRepos) {
        if (!hidden) {
            for (DownloadListener listener : this.downloadListeners) {
                listener.onDownloadDependency(groupId, artifactId, version);
            }
        }
        if (CP != null) {
            Object target = artifactId;
            if (version != null) {
                target = (String)target + "-" + version;
            }
            if (CP.contains((CharSequence)target)) {
                return;
            }
        }
        if (version == null) {
            return;
        }
        String gav = groupId + ":" + artifactId + ":" + version;
        this.threadPool.download(LOG, () -> {
            if (this.verbose) {
                LOG.info("Downloading: {}", (Object)gav);
            } else {
                LOG.debug("Downloading: {}", (Object)gav);
            }
            List<String> deps = List.of(gav);
            boolean useApacheSnaphots = "org.apache.camel".equals(groupId) && version.contains("SNAPSHOT");
            LinkedHashSet<String> extraRepositories = new LinkedHashSet<String>(this.resolveExtraRepositories(extraRepos));
            if (this.knownReposResolver != null) {
                String known = this.knownReposResolver.getRepo(artifactId);
                extraRepositories.addAll(this.resolveExtraRepositories(known));
            }
            List<MavenArtifact> artifacts = this.resolveDependenciesViaAether(deps, extraRepositories, transitively, useApacheSnaphots);
            ArrayList<File> files = new ArrayList<File>();
            if (this.verbose) {
                LOG.info("Resolved {} -> [{}]", (Object)gav, artifacts);
            } else {
                LOG.debug("Resolved {} -> [{}]", (Object)gav, artifacts);
            }
            for (MavenArtifact a : artifacts) {
                File file = a.getFile();
                if (this.alreadyOnClasspath(a.getGav().getGroupId(), a.getGav().getArtifactId(), a.getGav().getVersion(), false)) continue;
                if (this.classLoader instanceof DependencyDownloaderClassLoader) {
                    DependencyDownloaderClassLoader dependencyDownloaderClassLoader = (DependencyDownloaderClassLoader)this.classLoader;
                    dependencyDownloaderClassLoader.addFile(file);
                }
                files.add(file);
                if (this.verbose) {
                    LOG.info("Added classpath: {}", (Object)a.getGav());
                    continue;
                }
                LOG.debug("Added classpath: {}", (Object)a.getGav());
            }
            for (File file : files) {
                for (ArtifactDownloadListener artifactDownloadListener : this.artifactDownloadListeners) {
                    artifactDownloadListener.onDownloadedFile(file);
                }
            }
            if (!artifacts.isEmpty()) {
                for (DownloadListener listener : this.downloadListeners) {
                    listener.onDownloadedDependency(groupId, artifactId, version);
                }
            }
            if (!extraRepositories.isEmpty()) {
                for (String repo : extraRepositories) {
                    for (DownloadListener downloadListener : this.downloadListeners) {
                        downloadListener.onExtraRepository(repo);
                    }
                }
            }
        }, gav);
    }

    @Override
    public MavenArtifact downloadArtifact(String groupId, String artifactId, String version) {
        String gav = groupId + ":" + artifactId + ":" + version;
        if (this.verbose) {
            LOG.info("DownloadingArtifact: {}", (Object)gav);
        } else {
            LOG.debug("DownloadingArtifact: {}", (Object)gav);
        }
        List<CallSite> deps = List.of(gav);
        boolean useApacheSnaphots = "org.apache.camel".equals(groupId) && version.contains("SNAPSHOT");
        List<MavenArtifact> artifacts = this.resolveDependenciesViaAether(deps, null, false, useApacheSnaphots);
        if (this.verbose) {
            LOG.info("Resolved {} -> [{}]", (Object)gav, artifacts);
        } else {
            LOG.debug("Resolved {} -> [{}]", (Object)gav, artifacts);
        }
        if (artifacts.size() == 1) {
            return artifacts.get(0);
        }
        return null;
    }

    @Override
    public List<String[]> resolveAvailableVersions(String groupId, String artifactId, String minimumVersion, String repo) {
        String gav = groupId + ":" + artifactId;
        if (this.verbose) {
            LOG.info("DownloadAvailableVersions: {}", (Object)gav);
        } else {
            LOG.debug("DownloadAvailableVersions: {}", (Object)gav);
        }
        ArrayList<String[]> answer = new ArrayList<String[]>();
        try {
            List gavs = this.mavenDownloader.resolveAvailableVersions(groupId, artifactId, repo);
            Set<String> extraRepos = repo == null ? null : Collections.singleton(repo);
            for (MavenGav mavenGav : gavs) {
                String v = mavenGav.getVersion();
                if ("camel-spring-boot".equals(artifactId)) {
                    String sbv = null;
                    if (VersionHelper.isGE(v, minimumVersion)) {
                        sbv = this.resolveSpringBootVersionByCamelVersion(v, extraRepos);
                    }
                    answer.add(new String[]{v, sbv});
                    continue;
                }
                if ("camel-quarkus-catalog".equals(artifactId)) {
                    String cv;
                    if (!VersionHelper.isGE(v, MINIMUM_QUARKUS_VERSION) || (cv = this.resolveCamelVersionByQuarkusVersion(v, extraRepos)) == null || !VersionHelper.isGE(cv, minimumVersion)) continue;
                    answer.add(new String[]{cv, v});
                    continue;
                }
                answer.add(new String[]{v, null});
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new DownloadException(e.getMessage(), e);
        }
        return answer;
    }

    @Override
    public boolean alreadyOnClasspath(String groupId, String artifactId, String version) {
        return this.alreadyOnClasspath(groupId, artifactId, version, true);
    }

    private boolean alreadyOnClasspath(String groupId, String artifactId, String version, boolean listener) {
        if (artifactId == null) {
            return true;
        }
        Object target = artifactId;
        if (version != null) {
            target = (String)target + "-" + version;
        }
        if (this.bootClasspath != null) {
            for (String s : this.bootClasspath) {
                if (!s.contains((CharSequence)target)) continue;
                if (listener) {
                    for (DownloadListener dl : this.downloadListeners) {
                        dl.onDownloadDependency(groupId, artifactId, version);
                    }
                }
                return true;
            }
        }
        if (this.classLoader instanceof URLClassLoader) {
            Object urlTarget = groupId + "/" + artifactId;
            urlTarget = ((String)urlTarget).replace('.', '/');
            urlTarget = (String)urlTarget + "/" + version + "/" + (String)target + ".jar";
            urlTarget = FileUtil.normalizePath((String)urlTarget);
            URLClassLoader ucl = (URLClassLoader)this.classLoader;
            for (URL u : ucl.getURLs()) {
                String s = u.toString();
                if (!(s = FileUtil.normalizePath((String)s)).contains((CharSequence)urlTarget)) continue;
                if (listener) {
                    for (DownloadListener dl : this.downloadListeners) {
                        dl.onDownloadDependency(groupId, artifactId, version);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onLoadingKamelet(String name) {
        for (DownloadListener listener : this.downloadListeners) {
            listener.onLoadingKamelet(name);
        }
    }

    @Override
    public void onLoadingModeline(String key, String value) {
        for (DownloadListener listener : this.downloadListeners) {
            listener.onLoadingModeline(key, value);
        }
    }

    @Override
    public DownloadRecord getDownloadState(String groupId, String artifactId, String version) {
        return this.downloadRecords.get(groupId + ":" + artifactId + ":" + version);
    }

    @Override
    public Collection<DownloadRecord> downloadRecords() {
        return this.downloadRecords.values();
    }

    private Set<String> resolveExtraRepositories(String repositoryList) {
        LinkedHashSet<String> repositories = new LinkedHashSet<String>();
        if (repositoryList != null) {
            for (String repo : repositoryList.split("\\s*,\\s*")) {
                try {
                    URL url = new URL(repo);
                    if (url.getHost().equals("repo1.maven.org")) continue;
                    repositories.add(url.toExternalForm());
                }
                catch (MalformedURLException e) {
                    LOG.warn("Cannot use {} URL: {}. Skipping.", new Object[]{repo, e.getMessage(), e});
                }
            }
        }
        return repositories;
    }

    protected void doBuild() {
        if (this.classLoader == null && this.camelContext != null) {
            this.classLoader = this.camelContext.getApplicationContextClassLoader();
        }
        this.threadPool = new DownloadThreadPool(this);
        this.threadPool.setVerbose(this.verbose);
        this.threadPool.setCamelContext(this.camelContext);
        ServiceHelper.buildService((Object)((Object)this.threadPool));
        MavenDownloaderImpl mavenDownloaderImpl = new MavenDownloaderImpl();
        mavenDownloaderImpl.setMavenSettingsLocation(this.mavenSettings);
        mavenDownloaderImpl.setMavenSettingsSecurityLocation(this.mavenSettingsSecurity);
        mavenDownloaderImpl.setRepos(this.repos);
        mavenDownloaderImpl.setFresh(this.fresh);
        mavenDownloaderImpl.setRemoteArtifactDownloadListener((groupId, artifactId, version, repoId, repoUrl, elapsed) -> {
            String gav = groupId + ":" + artifactId + ":" + version;
            this.downloadRecords.put(gav, new DownloadRecord(groupId, artifactId, version, repoId, repoUrl, elapsed));
        });
        ServiceHelper.buildService((Object)mavenDownloaderImpl);
        this.mavenDownloader = mavenDownloaderImpl;
    }

    protected void doInit() {
        RuntimeMXBean mb = ManagementFactory.getRuntimeMXBean();
        if (mb != null) {
            this.bootClasspath = mb.getClassPath().split("[:|;]");
        }
        ServiceHelper.initService((Object)((Object)this.threadPool));
        ServiceHelper.initService((Object)this.mavenDownloader);
    }

    protected void doStop() {
        ServiceHelper.stopAndShutdownService((Object)this.mavenDownloader);
        ServiceHelper.stopAndShutdownService((ShutdownableService)this.threadPool);
    }

    public List<MavenArtifact> resolveDependenciesViaAether(List<String> depIds, Set<String> extraRepositories, boolean transitively, boolean useApacheSnapshots) {
        try {
            return this.mavenDownloader.resolveArtifacts(depIds, extraRepositories, transitively, useApacheSnapshots);
        }
        catch (MavenResolutionException e) {
            String repos = e.getRepositories() == null ? "(empty URL list)" : String.join((CharSequence)", ", e.getRepositories());
            String msg = "Cannot resolve dependencies in " + repos;
            throw new DownloadException(msg, e);
        }
        catch (RuntimeException e) {
            throw new DownloadException("Unknown error occurred while trying to resolve dependencies", e);
        }
    }

    private String resolveCamelVersionByQuarkusVersion(String quarkusVersion, Set<String> extraRepos) throws Exception {
        String gav = "org.apache.camel.quarkus:camel-quarkus:pom:" + quarkusVersion;
        try {
            DocumentBuilderFactory dbf;
            DocumentBuilder db;
            Document dom;
            NodeList nl;
            String name;
            File file;
            MavenArtifact ma;
            List<MavenArtifact> artifacts = this.resolveDependenciesViaAether(List.of(gav), extraRepos, false, false);
            if (!artifacts.isEmpty() && (ma = artifacts.get(0)) != null && ma.getFile() != null && (file = new File(name = ma.getFile().getAbsolutePath())).exists() && (nl = (dom = (db = (dbf = XmlHelper.createDocumentBuilderFactory()).newDocumentBuilder()).parse(file)).getElementsByTagName("parent")).getLength() == 1) {
                Element node = (Element)nl.item(0);
                return node.getElementsByTagName("version").item(0).getTextContent();
            }
        }
        catch (DownloadException ex) {
            LOG.debug(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private String resolveSpringBootVersionByCamelVersion(String camelVersion, Set<String> extraRepos) throws Exception {
        DocumentBuilderFactory dbf;
        DocumentBuilder db;
        Document dom;
        NodeList nl;
        String name;
        File file;
        MavenArtifact ma;
        String gav = "org.apache.camel.springboot:spring-boot:pom:" + camelVersion;
        List<MavenArtifact> artifacts = this.resolveDependenciesViaAether(List.of(gav), extraRepos, false, false);
        if (!artifacts.isEmpty() && (ma = artifacts.get(0)) != null && ma.getFile() != null && (file = new File(name = ma.getFile().getAbsolutePath())).exists() && (nl = (dom = (db = (dbf = XmlHelper.createDocumentBuilderFactory()).newDocumentBuilder()).parse(file)).getElementsByTagName("properties")).getLength() > 0) {
            Element node = (Element)nl.item(0);
            return node.getElementsByTagName("spring-boot-version").item(0).getTextContent();
        }
        return null;
    }
}

