/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.util.StringHelper;

public final class VersionHelper {
    private static final String KAMELETS_DEFAULT_VERSION = "4.0.0-RC1";
    private static final Pattern KAMELETS_LIBRARY = Pattern.compile("camel-kamelets-(\\d[A-Z\\d.-]*).jar", 32);
    private static final String CP = System.getProperty("java.class.path");

    private VersionHelper() {
    }

    public static boolean isGE(String source, String target) {
        return VersionHelper.compare(source, target) >= 0;
    }

    public static int compare(String source, String target) {
        Object s3;
        if (source == null || target == null) {
            return 0;
        }
        Object s1 = StringHelper.before((String)source, (String)".");
        Object s2 = StringHelper.after((String)source, (String)".");
        if (s1 == null) {
            s1 = StringHelper.before((String)source, (String)",");
            s2 = StringHelper.after((String)source, (String)",");
        }
        Object t1 = StringHelper.before((String)target, (String)".");
        Object t2 = StringHelper.after((String)target, (String)".");
        if (t1 == null) {
            t1 = StringHelper.before((String)target, (String)",");
            t2 = StringHelper.after((String)target, (String)",");
        }
        if ((s3 = StringHelper.after((String)s2, (String)".")) != null) {
            s2 = StringHelper.before((String)s2, (String)".");
        } else {
            s3 = "";
        }
        Object t3 = StringHelper.after((String)t2, (String)".");
        if (t3 != null) {
            t2 = StringHelper.before((String)t2, (String)".");
        } else {
            t3 = "";
        }
        if (((String)s1).length() < 2) {
            s1 = "0" + (String)s1;
        }
        if (((String)s2).length() < 2) {
            s2 = "0" + (String)s2;
        }
        if (((String)s2).length() < 2) {
            s2 = "0" + (String)s2;
        }
        if (((String)s3).length() < 2) {
            s3 = "0" + (String)s3;
        }
        if (((String)t1).length() < 2) {
            t1 = "0" + (String)t1;
        }
        if (((String)t2).length() < 2) {
            t2 = "0" + (String)t2;
        }
        if (((String)t3).length() < 2) {
            t3 = "0" + (String)t3;
        }
        String s = (String)s1 + (String)s2 + (String)s3;
        String t = (String)t1 + (String)t2 + (String)t3;
        return s.compareTo(t);
    }

    public static String extractKameletsVersion() {
        Matcher matcher = KAMELETS_LIBRARY.matcher(CP);
        if (matcher.find() && matcher.groupCount() > 0) {
            return matcher.group(1);
        }
        RuntimeMXBean mb = ManagementFactory.getRuntimeMXBean();
        if (mb != null && (matcher = KAMELETS_LIBRARY.matcher(mb.getClassPath())).find() && matcher.groupCount() > 0) {
            return matcher.group(1);
        }
        return KAMELETS_DEFAULT_VERSION;
    }
}

