/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.impl.engine.DefaultDataFormatResolver;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.stub.StubDataFormat;
import org.apache.camel.main.util.SuggestSimilarHelper;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.tooling.model.DataFormatModel;

public final class DependencyDownloaderDataFormatResolver
extends DefaultDataFormatResolver {
    private final CamelCatalog catalog = new DefaultCamelCatalog();
    private final DependencyDownloader downloader;
    private final String stubPattern;
    private final boolean silent;

    public DependencyDownloaderDataFormatResolver(CamelContext camelContext, String stubPattern, boolean silent) {
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
        this.stubPattern = stubPattern;
        this.silent = silent;
    }

    public DataFormat createDataFormat(String name, CamelContext context) {
        List<String> suggestion;
        boolean accept;
        StubDataFormat answer;
        DataFormatModel model = this.catalog.dataFormatModel(name);
        if (model != null) {
            this.downloadLoader(model.getGroupId(), model.getArtifactId(), model.getVersion());
        }
        if ((answer = (accept = this.accept(name)) ? super.createDataFormat(name, context) : new StubDataFormat()) == null && (suggestion = SuggestSimilarHelper.didYouMean(this.catalog.findDataFormatNames(), name)) != null && !suggestion.isEmpty()) {
            String s = String.join((CharSequence)", ", suggestion);
            throw new IllegalArgumentException("Cannot find dataformat with name: " + name + ". Did you mean: " + s);
        }
        return answer;
    }

    private void downloadLoader(String groupId, String artifactId, String version) {
        if (!this.downloader.alreadyOnClasspath(groupId, artifactId, version)) {
            this.downloader.downloadDependency(groupId, artifactId, version);
        }
    }

    private boolean accept(String name) {
        return this.stubPattern == null;
    }
}

