/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.console;

import java.util.Map;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.main.download.DownloadRecord;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="dependency-downloader")
public class DependencyDownloaderConsole
extends AbstractDevConsole {
    public DependencyDownloaderConsole() {
        super("jvm", "dependency-downloader", "Maven Dependency Downloader", "Displays information about dependencies downloaded at runtime");
    }

    protected String doCallText(Map<String, Object> options) {
        ClassLoader cl;
        StringBuilder sb = new StringBuilder();
        MavenDependencyDownloader downloader = (MavenDependencyDownloader)this.getCamelContext().hasService(MavenDependencyDownloader.class);
        if (downloader != null) {
            sb.append("Offline: ").append(!downloader.isDownload());
            sb.append("\nFresh:   ").append(downloader.isFresh());
            sb.append("\nVerbose: ").append(downloader.isVerbose());
            if (downloader.getRepos() != null) {
                sb.append("\nExtra Repositories: ").append(downloader.getRepos());
            }
            sb.append("\n");
            sb.append("\nDownloads:");
            for (DownloadRecord r : downloader.downloadRecords()) {
                sb.append("\n    ").append(String.format("%s:%s:%s (took: %s) from: %s@%s", r.groupId(), r.artifactId(), r.version(), TimeUtils.printDuration((long)r.elapsed(), (boolean)true), r.repoId(), r.repoUrl()));
            }
        }
        if ((cl = this.getCamelContext().getApplicationContextClassLoader()) instanceof DependencyDownloaderClassLoader) {
            DependencyDownloaderClassLoader ddcl = (DependencyDownloaderClassLoader)cl;
            sb.append("\n\nDependencies:");
            String cp = String.join((CharSequence)"\n    ", ddcl.getDownloaded());
            sb.append("\n    ").append(cp).append("\n");
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        MavenDependencyDownloader downloader;
        JsonObject root = new JsonObject();
        ClassLoader cl = this.getCamelContext().getApplicationContextClassLoader();
        if (cl instanceof DependencyDownloaderClassLoader) {
            DependencyDownloaderClassLoader ddcl = (DependencyDownloaderClassLoader)cl;
            String[] cp = ddcl.getDownloaded().toArray(new String[0]);
            root.put((Object)"dependencies", (Object)cp);
        }
        if ((downloader = (MavenDependencyDownloader)this.getCamelContext().hasService(MavenDependencyDownloader.class)) != null) {
            JsonArray arr = new JsonArray();
            root.put((Object)"offline", (Object)(!downloader.isDownload() ? 1 : 0));
            root.put((Object)"fresh", (Object)downloader.isFresh());
            root.put((Object)"verbose", (Object)downloader.isVerbose());
            root.put((Object)"repos", (Object)downloader.getRepos());
            root.put((Object)"downloads", (Object)arr);
            for (DownloadRecord r : downloader.downloadRecords()) {
                JsonObject jo = new JsonObject();
                arr.add((Object)jo);
                jo.put((Object)"groupId", (Object)r.groupId());
                jo.put((Object)"artifactId", (Object)r.artifactId());
                jo.put((Object)"version", (Object)r.version());
                jo.put((Object)"elapsed", (Object)r.elapsed());
                jo.put((Object)"repoId", (Object)r.repoId());
                jo.put((Object)"repoUrl", (Object)r.repoUrl());
            }
        }
        return root;
    }
}

