/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.impl.engine.DefaultLanguageResolver;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.stub.StubLanguage;
import org.apache.camel.main.util.SuggestSimilarHelper;
import org.apache.camel.spi.Language;
import org.apache.camel.tooling.model.LanguageModel;

public final class DependencyDownloaderLanguageResolver
extends DefaultLanguageResolver {
    private static final String ACCEPTED_STUB_NAMES = "constant,exchangeProperty,header,ref,simple";
    private final CamelCatalog catalog = new DefaultCamelCatalog();
    private final DependencyDownloader downloader;
    private final String stubPattern;
    private final boolean silent;

    public DependencyDownloaderLanguageResolver(CamelContext camelContext, String stubPattern, boolean silent) {
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
        this.stubPattern = stubPattern;
        this.silent = silent;
    }

    public Language resolveLanguage(String name, CamelContext context) {
        List<String> suggestion;
        boolean accept;
        StubLanguage answer;
        LanguageModel model = this.catalog.languageModel(name);
        if (model != null) {
            this.downloadLoader(model.getGroupId(), model.getArtifactId(), model.getVersion());
            if ("csimple".equals(name)) {
                this.downloadLoader(model.getGroupId(), "camel-csimple-joor", model.getVersion());
            }
        }
        if ((answer = (accept = this.accept(name)) ? super.resolveLanguage(name, context) : new StubLanguage()) == null && (suggestion = SuggestSimilarHelper.didYouMean(this.catalog.findDataFormatNames(), name)) != null && !suggestion.isEmpty()) {
            String s = String.join((CharSequence)", ", suggestion);
            throw new IllegalArgumentException("Cannot find language with name: " + name + ". Did you mean: " + s);
        }
        return answer;
    }

    private void downloadLoader(String groupId, String artifactId, String version) {
        if (!this.downloader.alreadyOnClasspath(groupId, artifactId, version)) {
            this.downloader.downloadDependency(groupId, artifactId, version);
        }
    }

    private boolean accept(String name) {
        if (this.stubPattern == null) {
            return true;
        }
        return ACCEPTED_STUB_NAMES.contains(name);
    }
}

