/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.main.download.DownloadRecord;
import org.apache.camel.main.download.MavenDependencyDownloader;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;

class DownloadThreadPool
extends ServiceSupport
implements CamelContextAware {
    private final MavenDependencyDownloader downloader;
    private CamelContext camelContext;
    private volatile ExecutorService executorService;
    private boolean verbose;

    public DownloadThreadPool(MavenDependencyDownloader downloader) {
        this.downloader = downloader;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void download(Logger log, Runnable task, String gav) {
        Future<?> future = this.executorService.submit(task);
        this.awaitCompletion(log, future, gav);
    }

    void awaitCompletion(Logger log, Future<?> future, String gav) {
        StopWatch watch = new StopWatch();
        boolean done = false;
        while (!done) {
            try {
                future.get(5000L, TimeUnit.MILLISECONDS);
                done = true;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Interrupted while downloading: {}", (Object)e.getMessage(), (Object)e);
                return;
            }
            catch (Exception e) {
                log.error("Error downloading: {} due to: {}", new Object[]{gav, e.getMessage(), e});
                return;
            }
            if (done) continue;
            log.info("Downloading: {} (elapsed: {})", (Object)gav, (Object)TimeUtils.printDuration((long)watch.taken()));
        }
        MavenGav a = MavenGav.parseGav((String)gav);
        DownloadRecord downloadRecord = this.downloader.getDownloadState(a.getGroupId(), a.getArtifactId(), a.getVersion());
        if (downloadRecord != null) {
            long taken = watch.taken();
            String url = downloadRecord.repoUrl();
            String id = downloadRecord.repoId();
            String msg = "Downloaded: " + gav + " (took: " + TimeUtils.printDuration((long)taken, (boolean)true) + ") from: " + id + "@" + url;
            log.info(msg);
        } else {
            long taken = watch.taken();
            String msg = "Resolved: " + gav + " (took: " + TimeUtils.printDuration((long)taken, (boolean)true) + ")";
            if (this.verbose || taken > 2000L) {
                log.info(msg);
            } else {
                log.debug(msg);
            }
        }
    }

    protected void doBuild() throws Exception {
        this.executorService = this.camelContext != null ? this.camelContext.getExecutorServiceManager().newCachedThreadPool((Object)this, "MavenDownload") : Executors.newCachedThreadPool();
        this.downloader.setVerbose(this.verbose);
    }

    protected void doShutdown() throws Exception {
        if (this.executorService != null && this.camelContext != null) {
            this.camelContext.getExecutorServiceManager().shutdown(this.executorService);
        } else if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

