/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import org.apache.camel.Route;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.reifier.ProcessReifier;
import org.apache.camel.reifier.ProcessorReifier;

public final class CircuitBreakerDownloader {
    private CircuitBreakerDownloader() {
    }

    public static void registerDownloadReifiers() {
        ProcessorReifier.registerReifier(CircuitBreakerDefinition.class, (route, processorDefinition) -> {
            if (processorDefinition instanceof CircuitBreakerDefinition) {
                CircuitBreakerDefinition cb = (CircuitBreakerDefinition)processorDefinition;
                DependencyDownloader downloader = (DependencyDownloader)route.getCamelContext().hasService(DependencyDownloader.class);
                if (downloader != null) {
                    if (cb.getResilience4jConfiguration() != null) {
                        downloader.downloadDependency("org.apache.camel", "camel-resilience4j", route.getCamelContext().getVersion());
                    }
                    if (cb.getFaultToleranceConfiguration() != null) {
                        downloader.downloadDependency("org.apache.camel", "camel-microprofile-fault-tolerance", route.getCamelContext().getVersion());
                    }
                    if (cb.getConfiguration() != null) {
                        String id = cb.getConfiguration();
                        Resilience4jConfigurationDefinition cfg = ((ModelCamelContext)route.getCamelContext()).getResilience4jConfiguration(id);
                        if (cfg != null) {
                            downloader.downloadDependency("org.apache.camel", "camel-resilience4j", route.getCamelContext().getVersion());
                        }
                        if ((cfg = ((ModelCamelContext)route.getCamelContext()).getFaultToleranceConfiguration(id)) != null) {
                            downloader.downloadDependency("org.apache.camel", "camel-microprofile-fault-tolerance", route.getCamelContext().getVersion());
                        }
                    }
                }
            }
            return ProcessReifier.coreReifier((Route)route, (ProcessorDefinition)processorDefinition);
        });
    }
}

