/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.kamelet.KameletComponent;
import org.apache.camel.dsl.yaml.YamlRoutesBuilderLoaderSupport;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.util.VersionHelper;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RouteTemplateLoaderListener;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.tooling.maven.MavenGav;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

public final class DependencyDownloaderKamelet
extends ServiceSupport
implements CamelContextAware,
RouteTemplateLoaderListener {
    private String kameletsVersion;
    private KameletDependencyDownloader downloader;
    private CamelContext camelContext;

    public DependencyDownloaderKamelet(CamelContext camelContext) {
        this(camelContext, null);
    }

    public DependencyDownloaderKamelet(CamelContext camelContext, String kameletsVersion) {
        this.camelContext = camelContext;
        this.kameletsVersion = kameletsVersion;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doBuild() throws Exception {
        KameletComponent kc = (KameletComponent)this.camelContext.getComponent("kamelet", KameletComponent.class);
        kc.setRouteTemplateLoaderListener((RouteTemplateLoaderListener)this);
    }

    protected void doInit() throws Exception {
        if (this.kameletsVersion == null) {
            this.kameletsVersion = VersionHelper.extractKameletsVersion();
        }
        this.downloader = new KameletDependencyDownloader(this.camelContext, "yaml", this.kameletsVersion);
        this.downloader.setCamelContext(this.camelContext);
        ServiceHelper.initService((Object)((Object)this.downloader));
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Service)this.downloader);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Service)this.downloader);
    }

    public void loadRouteTemplate(Resource resource) {
        if (resource.getLocation().endsWith(".yaml")) {
            try {
                this.downloader.doLoadRouteBuilder(resource);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
    }

    private static class KameletDependencyDownloader
    extends YamlRoutesBuilderLoaderSupport {
        private static final Logger LOG = LoggerFactory.getLogger(KameletDependencyDownloader.class);
        private final CamelContext camelContext;
        private final DependencyDownloader downloader;
        private final Set<String> downloaded = new HashSet<String>();
        private final String kameletsVersion;

        public KameletDependencyDownloader(CamelContext camelContext, String extension, String kameletsVersion) {
            super(extension);
            this.camelContext = camelContext;
            this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
            this.kameletsVersion = kameletsVersion;
        }

        protected RouteBuilder builder(YamlDeserializationContext ctx, Node node) {
            Node name = YamlDeserializerSupport.nodeAt((Node)node, (String)"/metadata/name");
            String text = YamlDeserializerSupport.asText((Node)name);
            if (this.downloader != null) {
                this.downloader.onLoadingKamelet(text);
            }
            ArrayList<String> dependencies = new ArrayList<String>();
            Node deps = YamlDeserializerSupport.nodeAt((Node)node, (String)"/spec/dependencies");
            if (deps != null && deps.getNodeType() == NodeType.SEQUENCE) {
                SequenceNode sn = (SequenceNode)deps;
                for (Node child : sn.getValue()) {
                    ScalarNode scn;
                    String dep;
                    if (child.getNodeType() != NodeType.SCALAR || (dep = (scn = (ScalarNode)child).getValue()) == null) continue;
                    LOG.trace("Kamelet dependency: {}", (Object)dep);
                    dependencies.add(dep);
                }
            }
            if (this.downloader != null) {
                this.downloadDependencies(dependencies);
            }
            return new RouteBuilder(){

                public void configure() throws Exception {
                }
            };
        }

        private void downloadDependencies(List<String> dependencies) {
            ArrayList<Object> gavs = new ArrayList<Object>();
            for (String string : dependencies) {
                Object gav = string;
                if (string.startsWith("camel:")) {
                    gav = "org.apache.camel:camel-" + string.substring("camel:".length()) + ":" + this.camelContext.getVersion();
                } else if (string.startsWith("camel-kamelets:")) {
                    gav = "org.apache.camel.kamelets:camel-kamelets-" + string.substring("camel-kamelets:".length()) + ":" + this.kameletsVersion;
                }
                if (!this.isValidGav((String)gav)) continue;
                gavs.add(gav);
            }
            if (!gavs.isEmpty()) {
                for (String string : gavs) {
                    MavenGav mg = MavenGav.parseGav((String)string, (String)this.camelContext.getVersion());
                    this.downloader.downloadDependency(mg.getGroupId(), mg.getArtifactId(), mg.getVersion());
                    this.downloaded.add(string);
                }
            }
        }

        private boolean isValidGav(String gav) {
            if (this.downloaded.contains(gav)) {
                return false;
            }
            if (gav.contains("org.apache.camel:camel-core") || gav.contains("org.apache.camel:camel-kamelet:")) {
                return false;
            }
            MavenGav mg = MavenGav.parseGav((String)gav, (String)this.camelContext.getVersion());
            boolean exists = this.downloader.alreadyOnClasspath(mg.getGroupId(), mg.getArtifactId(), mg.getVersion());
            return !exists;
        }
    }
}

