/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.injection;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelConfiguration;
import org.apache.camel.CamelContext;
import org.apache.camel.Configuration;
import org.apache.camel.Converter;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.impl.engine.CamelPostProcessorHelper;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelBeanPostProcessorInjector;
import org.apache.camel.spi.CompilePostProcessor;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

public final class AnnotationDependencyInjection {
    private AnnotationDependencyInjection() {
    }

    public static void initAnnotationBasedDependencyInjection(CamelContext context) {
        Registry registry = context.getRegistry();
        CamelBeanPostProcessor cbbp = PluginHelper.getBeanPostProcessor((CamelContext)context);
        registry.bind("CamelTypeConverterCompilePostProcessor", (Object)new TypeConverterCompilePostProcessor());
        registry.bind("CamelEventNotifierCompilePostProcessor", (Object)new EventNotifierCompilePostProcessor());
        registry.bind("CamelBindToRegistryCompilePostProcessor", (Object)new BindToRegistryCompilePostProcessor());
        registry.bind("SpringAnnotationCompilePostProcessor", (Object)new SpringAnnotationCompilePostProcessor());
        cbbp.addCamelBeanPostProjectInjector((CamelBeanPostProcessorInjector)new SpringBeanPostProcessorInjector(context));
        registry.bind("QuarkusAnnotationCompilePostProcessor", (Object)new QuarkusAnnotationCompilePostProcessor());
        cbbp.addCamelBeanPostProjectInjector((CamelBeanPostProcessorInjector)new QuarkusBeanPostProcessorInjector(context));
    }

    private static void bindBean(CamelContext context, String name, Object instance, boolean postProcess) {
        Registry registry = context.getRegistry();
        CamelBeanPostProcessor bpp = PluginHelper.getBeanPostProcessor((CamelContext)context);
        bpp.setUnbindEnabled(true);
        try {
            registry.unbind(name);
            registry.bind(name, instance);
            if (postProcess) {
                bpp.postProcessBeforeInitialization(instance, name);
                bpp.postProcessAfterInitialization(instance, name);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
        finally {
            bpp.setUnbindEnabled(false);
        }
    }

    private static class TypeConverterCompilePostProcessor
    implements CompilePostProcessor {
        private TypeConverterCompilePostProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postCompile(CamelContext camelContext, String name, Class<?> clazz, byte[] byteCode, Object instance) throws Exception {
            if (clazz.isAnnotationPresent(Converter.class)) {
                TypeConverterRegistry tcr = camelContext.getTypeConverterRegistry();
                TypeConverterExists exists = tcr.getTypeConverterExists();
                LoggingLevel level = tcr.getTypeConverterExistsLoggingLevel();
                tcr.setTypeConverterExists(TypeConverterExists.Override);
                tcr.setTypeConverterExistsLoggingLevel(LoggingLevel.OFF);
                try {
                    tcr.addTypeConverters(clazz);
                }
                finally {
                    tcr.setTypeConverterExists(exists);
                    tcr.setTypeConverterExistsLoggingLevel(level);
                }
            }
        }
    }

    private static class EventNotifierCompilePostProcessor
    implements CompilePostProcessor {
        private final Map<String, EventNotifier> notifiers = new HashMap<String, EventNotifier>();

        private EventNotifierCompilePostProcessor() {
        }

        public void postCompile(CamelContext camelContext, String name, Class<?> clazz, byte[] byteCode, Object instance) throws Exception {
            ManagementStrategy ms;
            if (instance == null) {
                return;
            }
            if (instance instanceof EventNotifier && (ms = camelContext.getManagementStrategy()) != null) {
                this.notifiers.compute(name, (key, old) -> {
                    if (old != null) {
                        ms.removeEventNotifier(old);
                    }
                    EventNotifier en = (EventNotifier)instance;
                    ms.addEventNotifier(en);
                    return en;
                });
            }
        }
    }

    private static class BindToRegistryCompilePostProcessor
    implements CompilePostProcessor {
        private BindToRegistryCompilePostProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postCompile(CamelContext camelContext, String name, Class<?> clazz, byte[] byteCode, Object instance) throws Exception {
            if (instance == null) {
                return;
            }
            BindToRegistry bir = instance.getClass().getAnnotation(BindToRegistry.class);
            Configuration cfg = instance.getClass().getAnnotation(Configuration.class);
            if (bir != null || cfg != null || instance instanceof CamelConfiguration) {
                CamelBeanPostProcessor bpp = PluginHelper.getBeanPostProcessor((CamelContext)camelContext);
                if (bir != null && ObjectHelper.isNotEmpty((String)bir.value())) {
                    name = bir.value();
                } else if (cfg != null && ObjectHelper.isNotEmpty((String)cfg.value())) {
                    name = cfg.value();
                }
                bpp.setUnbindEnabled(true);
                try {
                    bpp.postProcessBeforeInitialization(instance, name);
                    bpp.postProcessAfterInitialization(instance, name);
                }
                finally {
                    bpp.setUnbindEnabled(false);
                }
                if (instance instanceof CamelConfiguration) {
                    ((CamelConfiguration)instance).configure(camelContext);
                }
            }
        }
    }

    private static class SpringAnnotationCompilePostProcessor
    implements CompilePostProcessor {
        private SpringAnnotationCompilePostProcessor() {
        }

        public void postCompile(CamelContext camelContext, String name, Class<?> clazz, byte[] byteCode, Object instance) throws Exception {
            if (instance == null) {
                return;
            }
            Component comp = clazz.getAnnotation(Component.class);
            Service service = clazz.getAnnotation(Service.class);
            if (comp != null || service != null) {
                if (comp != null && ObjectHelper.isNotEmpty((String)comp.value())) {
                    name = comp.value();
                } else if (service != null && ObjectHelper.isNotEmpty((String)service.value())) {
                    name = service.value();
                }
                AnnotationDependencyInjection.bindBean(camelContext, name, instance, true);
            }
        }
    }

    private static class SpringBeanPostProcessorInjector
    implements CamelBeanPostProcessorInjector {
        private final CamelContext context;
        private final CamelPostProcessorHelper helper;

        public SpringBeanPostProcessorInjector(CamelContext context) {
            this.context = context;
            this.helper = new CamelPostProcessorHelper(context);
        }

        public void onFieldInject(Field field, Object bean, String beanName) {
            Value value;
            block5: {
                Autowired autowired = field.getAnnotation(Autowired.class);
                if (autowired != null) {
                    String name = null;
                    Qualifier qualifier = field.getAnnotation(Qualifier.class);
                    if (qualifier != null) {
                        name = qualifier.value();
                    }
                    try {
                        ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.helper.getInjectionBeanValue(field.getType(), name));
                    }
                    catch (NoSuchBeanException e) {
                        if (!autowired.required()) break block5;
                        throw e;
                    }
                }
            }
            if ((value = field.getAnnotation(Value.class)) != null) {
                ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.helper.getInjectionPropertyValue(field.getType(), value.value(), null, null, bean, beanName));
            }
        }

        public void onMethodInject(Method method, Object bean, String beanName) {
            Object instance;
            Bean bi = method.getAnnotation(Bean.class);
            if (bi != null && (instance = this.helper.getInjectionBeanMethodValue(this.context, method, bean, beanName)) != null) {
                String name = method.getName();
                if (bi.name().length > 0) {
                    name = bi.name()[0];
                }
                AnnotationDependencyInjection.bindBean(this.context, name, instance, false);
            }
        }
    }

    private static class QuarkusAnnotationCompilePostProcessor
    implements CompilePostProcessor {
        private QuarkusAnnotationCompilePostProcessor() {
        }

        public void postCompile(CamelContext camelContext, String name, Class<?> clazz, byte[] byteCode, Object instance) throws Exception {
            if (instance == null) {
                return;
            }
            ApplicationScoped as = clazz.getAnnotation(ApplicationScoped.class);
            Singleton ss = clazz.getAnnotation(Singleton.class);
            if (as != null || ss != null) {
                Named named = clazz.getAnnotation(Named.class);
                if (named != null) {
                    name = named.value();
                }
                AnnotationDependencyInjection.bindBean(camelContext, name, instance, true);
            }
        }
    }

    private static class QuarkusBeanPostProcessorInjector
    implements CamelBeanPostProcessorInjector {
        private final CamelContext context;
        private final CamelPostProcessorHelper helper;

        public QuarkusBeanPostProcessorInjector(CamelContext context) {
            this.context = context;
            this.helper = new CamelPostProcessorHelper(context);
        }

        public void onFieldInject(Field field, Object bean, String beanName) {
            ConfigProperty cp;
            Inject inject = field.getAnnotation(Inject.class);
            if (inject != null) {
                String name = null;
                Named named = field.getAnnotation(Named.class);
                if (named != null) {
                    name = named.value();
                }
                ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.helper.getInjectionBeanValue(field.getType(), name));
            }
            if ((cp = field.getAnnotation(ConfigProperty.class)) != null) {
                ReflectionHelper.setField((Field)field, (Object)bean, (Object)this.helper.getInjectionPropertyValue(field.getType(), cp.name(), cp.defaultValue(), null, bean, beanName));
            }
        }

        public void onMethodInject(Method method, Object bean, String beanName) {
            Object instance;
            Produces produces = method.getAnnotation(Produces.class);
            Named bi = method.getAnnotation(Named.class);
            if ((produces != null || bi != null) && (instance = this.helper.getInjectionBeanMethodValue(this.context, method, bean, beanName)) != null) {
                String name = method.getName();
                if (bi != null && !bi.value().isBlank()) {
                    name = bi.value();
                }
                AnnotationDependencyInjection.bindBean(this.context, name, instance, false);
            }
        }
    }
}

