/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.impl.engine.DefaultClassResolver;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.download.KnownDependenciesResolver;
import org.apache.camel.main.download.MainHttpServerFactory;
import org.apache.camel.main.download.ResourceResolverListener;
import org.apache.camel.tooling.maven.MavenGav;
import org.apache.camel.tooling.model.PojoBeanModel;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class DependencyDownloaderClassResolver
extends DefaultClassResolver {
    private final CamelCatalog catalog = new DefaultCamelCatalog();
    private final List<ResourceResolverListener> resourceResolverListeners = new ArrayList<ResourceResolverListener>();
    private final KnownDependenciesResolver knownDependenciesResolver;
    private final DependencyDownloader downloader;
    private final boolean silent;

    public DependencyDownloaderClassResolver(CamelContext camelContext, KnownDependenciesResolver knownDependenciesResolver, boolean silent) {
        super(camelContext);
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
        this.knownDependenciesResolver = knownDependenciesResolver;
        this.silent = silent;
        this.resourceResolverListeners.add(new KNativeHttpServerFactory());
    }

    public InputStream loadResourceAsStream(String uri) {
        this.resourceResolverListeners.forEach(l -> l.onLoadResourceAsStream(uri));
        InputStream answer = null;
        try {
            answer = super.loadResourceAsStream(uri);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (answer == null) {
            String last;
            PojoBeanModel model;
            MavenGav gav = this.knownDependenciesResolver.mavenGavForClass(uri);
            if (gav == null && (model = this.catalog.pojoBeanModel(last = StringHelper.afterLast((String)uri, (String)".", (String)uri))) != null && uri.equals(model.getJavaType())) {
                gav = MavenGav.fromCoordinates((String)model.getGroupId(), (String)model.getArtifactId(), (String)model.getVersion(), null, null);
            }
            if (gav != null) {
                if (!this.downloader.alreadyOnClasspath(gav.getGroupId(), gav.getArtifactId(), gav.getVersion())) {
                    this.downloader.downloadDependency(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                }
                try {
                    answer = super.loadResourceAsStream(uri);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return answer;
    }

    protected Class<?> loadClass(String name, ClassLoader loader) {
        Class answer = null;
        try {
            answer = ObjectHelper.loadClass((String)name, (ClassLoader)loader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (answer == null) {
            String last;
            PojoBeanModel model;
            MavenGav gav = this.knownDependenciesResolver.mavenGavForClass(name);
            if (gav == null && (model = this.catalog.pojoBeanModel(last = StringHelper.afterLast((String)name, (String)".", (String)name))) != null && name.equals(model.getJavaType())) {
                gav = MavenGav.fromCoordinates((String)model.getGroupId(), (String)model.getArtifactId(), (String)model.getVersion(), null, null);
            }
            if (gav != null) {
                if (!this.downloader.alreadyOnClasspath(gav.getGroupId(), gav.getArtifactId(), gav.getVersion())) {
                    this.downloader.downloadDependency(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                }
                try {
                    answer = ObjectHelper.loadClass((String)name, (ClassLoader)loader);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return answer;
    }

    private class KNativeHttpServerFactory
    implements ResourceResolverListener {
        private KNativeHttpServerFactory() {
        }

        @Override
        public void onLoadResourceAsStream(String uri) {
            try {
                if ("META-INF/services/org/apache/camel/knative/transport/http-consumer".equals(uri)) {
                    MainHttpServerFactory.setupHttpServer(DependencyDownloaderClassResolver.this.getCamelContext(), DependencyDownloaderClassResolver.this.silent);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

