/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import org.apache.camel.CamelContext;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.download.KnownDependenciesResolver;
import org.apache.camel.support.PropertyBindingListener;
import org.apache.camel.tooling.maven.MavenGav;

public class DependencyDownloaderPropertyBindingListener
implements PropertyBindingListener {
    private final KnownDependenciesResolver knownDependenciesResolver;
    private final DependencyDownloader downloader;

    public DependencyDownloaderPropertyBindingListener(CamelContext camelContext, KnownDependenciesResolver knownDependenciesResolver) {
        this.knownDependenciesResolver = knownDependenciesResolver;
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
    }

    public void bindProperty(Object target, String key, Object value) {
        if (value instanceof String) {
            String s = (String)value;
            MavenGav gav = this.knownDependenciesResolver.mavenGavForClass(s);
            if (gav == null) {
                String line = target.getClass().getName() + ":" + key + "=" + s;
                gav = this.knownDependenciesResolver.mavenGavForClass(line);
            }
            if (gav != null && !this.downloader.alreadyOnClasspath(gav.getGroupId(), gav.getArtifactId(), gav.getVersion())) {
                this.downloader.downloadDependency(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
            }
        }
    }
}

