/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.impl.engine.DefaultTransformerResolver;
import org.apache.camel.impl.engine.TransformerKey;
import org.apache.camel.main.download.DependencyDownloader;
import org.apache.camel.main.stub.StubTransformer;
import org.apache.camel.main.util.SuggestSimilarHelper;
import org.apache.camel.spi.Transformer;
import org.apache.camel.tooling.model.TransformerModel;

public final class DependencyDownloaderTransformerResolver
extends DefaultTransformerResolver {
    private final CamelCatalog catalog = new DefaultCamelCatalog();
    private final DependencyDownloader downloader;
    private final String stubPattern;
    private final boolean silent;

    public DependencyDownloaderTransformerResolver(CamelContext camelContext, String stubPattern, boolean silent) {
        this.downloader = (DependencyDownloader)camelContext.hasService(DependencyDownloader.class);
        this.stubPattern = stubPattern;
        this.silent = silent;
    }

    public Transformer resolve(TransformerKey key, CamelContext context) {
        List<String> suggestion;
        boolean accept;
        StubTransformer answer;
        String name = key.toString();
        TransformerModel model = this.catalog.transformerModel(name);
        if (model != null) {
            this.downloadLoader(model.getGroupId(), model.getArtifactId(), model.getVersion());
        }
        if ((answer = (accept = this.accept(name)) ? super.resolve(key, context) : new StubTransformer()) == null && (suggestion = SuggestSimilarHelper.didYouMean(this.catalog.findTransformerNames(), name)) != null && !suggestion.isEmpty()) {
            String s = String.join((CharSequence)", ", suggestion);
            throw new IllegalArgumentException("Cannot find transformer with name: " + name + ". Did you mean: " + s);
        }
        return answer;
    }

    private void downloadLoader(String groupId, String artifactId, String version) {
        if (!this.downloader.alreadyOnClasspath(groupId, artifactId, version)) {
            this.downloader.downloadDependency(groupId, artifactId, version);
        }
    }

    private boolean accept(String name) {
        return this.stubPattern == null;
    }
}

