/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.tooling.maven.MavenGav;

public final class KnownDependenciesResolver {
    private final Map<String, String> mappings = new HashMap<String, String>();
    private final CamelContext camelContext;

    public KnownDependenciesResolver(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void loadKnownDependencies() {
        this.doLoadKnownDependencies("/camel-main-known-dependencies.properties");
        this.doLoadKnownDependencies("/camel-component-known-dependencies.properties");
    }

    private void doLoadKnownDependencies(String name) {
        try {
            InputStream is = this.getClass().getResourceAsStream(name);
            if (is != null) {
                Properties prop = new Properties();
                prop.load(is);
                HashMap<String, String> map = new HashMap<String, String>();
                for (String key : prop.stringPropertyNames()) {
                    String value = prop.getProperty(key);
                    map.put(key, value);
                }
                this.addMappings(map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addMappings(Map<String, String> mappings) {
        this.mappings.putAll(mappings);
    }

    public MavenGav mavenGavForClass(String className) {
        String gav = this.mappings.get(className);
        if (gav != null) {
            return MavenGav.parseGav((String)gav, (String)this.camelContext.getVersion());
        }
        return null;
    }
}

