/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import org.apache.camel.CamelContext;
import org.apache.camel.Service;
import org.apache.camel.component.platform.http.main.MainHttpServer;
import org.apache.camel.main.HttpServerConfigurationProperties;
import org.apache.camel.main.util.CamelJBangSettingsHelper;

public class MainHttpServerFactory {
    public static MainHttpServer setupHttpServer(CamelContext camelContext, boolean silent) {
        MainHttpServer server = (MainHttpServer)camelContext.hasService(MainHttpServer.class);
        if (server == null) {
            HttpServerConfigurationProperties config = new HttpServerConfigurationProperties(null);
            CamelJBangSettingsHelper.writeSettingsIfNotExists("camel.jbang.platform-http.port", String.valueOf(config.getPort()));
            if (!silent) {
                try {
                    org.apache.camel.main.MainHttpServerFactory factory = MainHttpServerFactory.resolveMainHttpServerFactory(camelContext);
                    Service httpServer = factory.newHttpServer(config);
                    camelContext.addService((Object)httpServer, true, true);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return server;
    }

    private static org.apache.camel.main.MainHttpServerFactory resolveMainHttpServerFactory(CamelContext camelContext) throws Exception {
        org.apache.camel.main.MainHttpServerFactory answer = (org.apache.camel.main.MainHttpServerFactory)camelContext.getRegistry().findSingleByType(org.apache.camel.main.MainHttpServerFactory.class);
        if (answer == null) {
            answer = (org.apache.camel.main.MainHttpServerFactory)camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("platform-http-server", org.apache.camel.main.MainHttpServerFactory.class).orElseThrow(() -> new IllegalArgumentException("Cannot find MainHttpServerFactory on classpath. Add camel-platform-http-main to classpath."));
        }
        return answer;
    }
}

