/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.download;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.main.download.ArtifactDownloadListener;
import org.apache.camel.main.download.DependencyDownloaderClassLoader;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeConverterLoaderDownloadListener
implements ArtifactDownloadListener,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(TypeConverterLoaderDownloadListener.class);
    private CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void onDownloadedFile(File file) {
        try {
            this.loadTypeConverters(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadTypeConverters(File file) throws Exception {
        DependencyDownloaderClassLoader cl = new DependencyDownloaderClassLoader(null);
        cl.addFile(file);
        ArrayList<String> loaders = new ArrayList<String>();
        this.findTypeConverterLoaderClasses(loaders, cl.getResourceAsStream("META-INF/services/org/apache/camel/TypeConverterLoader"));
        this.findTypeConverterLoaderClasses(loaders, cl.getResourceAsStream("META-INF/services/org/apache/camel/FallbackTypeConverter"));
        this.loadTypeConverters(loaders);
    }

    protected void findTypeConverterLoaderClasses(Collection<String> loaders, InputStream is) throws IOException {
        if (is != null) {
            String line;
            BufferedReader reader = IOHelper.buffered((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
            do {
                if ((line = reader.readLine()) == null || line.startsWith("#") || line.isEmpty()) continue;
                loaders.add(line);
            } while (line != null);
            IOHelper.close((Closeable)reader);
        }
    }

    protected void loadTypeConverters(Collection<String> loaders) throws ClassNotFoundException {
        for (String name : loaders) {
            LOG.debug("Resolving TypeConverterLoader: {}", (Object)name);
            Class clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(name);
            Object obj = this.getCamelContext().getInjector().newInstance(clazz, false);
            CamelContextAware.trySetCamelContext((Object)obj, (CamelContext)this.getCamelContext());
            if (!(obj instanceof TypeConverterLoader)) continue;
            TypeConverterLoader loader = (TypeConverterLoader)obj;
            CamelContextAware.trySetCamelContext((Object)loader, (CamelContext)this.getCamelContext());
            LOG.debug("TypeConverterLoader: {} loading converters", (Object)name);
            loader.load(this.getCamelContext().getTypeConverterRegistry());
        }
    }
}

