/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.reload;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.models.openapi.OpenApiDocument;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.camel.generator.openapi.RestDslGenerator;
import org.apache.camel.support.FileWatcherResourceReloadStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiGeneratorReloadStrategy
extends FileWatcherResourceReloadStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiGeneratorReloadStrategy.class);
    private static final String OPENAPI_GENERATED_FILE = ".camel-jbang/generated-openapi.yaml";
    private final File openapi;

    public OpenApiGeneratorReloadStrategy(File openapi) {
        String parent = openapi.getParent();
        if (parent == null) {
            parent = ".";
        }
        this.setFolder(parent);
        Path dir = new File(parent).toPath();
        this.openapi = dir.resolve(openapi.toPath()).toFile();
        this.setFileFilter(this.openapi::equals);
        this.setResourceReload((name, resource) -> {
            if (!openapi.exists() && !openapi.isFile()) {
                return;
            }
            LOG.info("Generating open-api rest-dsl from: {}", (Object)openapi);
            try {
                boolean yaml = openapi.getName().endsWith(".yaml") || openapi.getName().endsWith(".yml");
                Object mapper = yaml ? new YAMLMapper() : new ObjectMapper();
                ObjectNode node = (ObjectNode)mapper.readTree(openapi);
                OpenApiDocument document = (OpenApiDocument)Library.readDocument((ObjectNode)node);
                String out = RestDslGenerator.toYaml((OpenApiDocument)document).generate(this.getCamelContext(), false);
                Files.write(Paths.get(OPENAPI_GENERATED_FILE, new String[0]), out.getBytes(), new OpenOption[0]);
            }
            catch (Exception e) {
                LOG.warn("Error generating open-api rest-dsl due: " + e.getMessage(), (Throwable)e);
            }
        });
    }
}

