/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main.xml.blueprint;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.util.XmlHelper;
import org.apache.camel.model.Model;
import org.apache.camel.model.app.RegistryBeanDefinition;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BlueprintXmlBeansHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintXmlBeansHandler.class);
    private static final Pattern BLUEPRINT_PATTERN = Pattern.compile("\\$\\{(.*?)}");
    private final Map<String, Node> delayedBeans = new LinkedHashMap<String, Node>();
    private final Map<String, Resource> resources = new LinkedHashMap<String, Resource>();
    private final List<RegistryBeanDefinition> delayedRegistrations = new ArrayList<RegistryBeanDefinition>();
    private final Map<String, KeyValueHolder<Object, String>> beansToDestroy = new LinkedHashMap<String, KeyValueHolder<Object, String>>();
    private boolean transform;

    public boolean isTransform() {
        return this.transform;
    }

    public void setTransform(boolean transform) {
        this.transform = transform;
    }

    public void processBlueprintBeans(CamelContext camelContext, MainConfigurationProperties config, Map<String, Document> xmls) {
        LOG.debug("Loading beans from classic OSGi <blueprint> XML");
        xmls.forEach((id, doc) -> {
            if (id.startsWith("camel-xml-io-dsl-blueprint-xml:")) {
                String fileName = StringHelper.afterLast((String)id, (String)":");
                this.discoverBeans(camelContext, fileName, (Document)doc);
            }
        });
    }

    public void createAndRegisterBeans(CamelContext camelContext) {
        if (this.delayedBeans.isEmpty()) {
            return;
        }
        LOG.info("Discovered {} OSGi <blueprint> XML beans", (Object)this.delayedBeans.size());
        for (Map.Entry<String, Node> entry : this.delayedBeans.entrySet()) {
            String id = entry.getKey();
            Node n = entry.getValue();
            RegistryBeanDefinition def = this.createBeanModel(camelContext, id, n);
            if (this.transform) {
                LOG.debug("Discovered bean: {}", (Object)def.getName());
                this.addBeanToCamelModel(camelContext, def.getName(), def);
                continue;
            }
            LOG.debug("Creating bean: {}", (Object)def.getName());
            this.registerAndCreateBean(camelContext, def, true);
        }
        if (!this.delayedRegistrations.isEmpty()) {
            for (RegistryBeanDefinition def : this.delayedRegistrations) {
                LOG.debug("Creating bean (2nd-try): {}", (Object)def.getName());
                this.registerAndCreateBean(camelContext, def, false);
            }
            this.delayedRegistrations.clear();
        }
    }

    private RegistryBeanDefinition createBeanModel(CamelContext camelContext, String name, Node node) {
        String dm;
        String im;
        String fm;
        RegistryBeanDefinition rrd = new RegistryBeanDefinition();
        rrd.setResource(this.resources.get(name));
        rrd.setType(XmlHelper.getAttribute(node, "class"));
        rrd.setName(name);
        String fb = XmlHelper.getAttribute(node, "factory-ref");
        if (fb != null) {
            rrd.setFactoryBean(fb);
        }
        if ((fm = XmlHelper.getAttribute(node, "factory-method")) != null) {
            rrd.setFactoryMethod(fm);
        }
        if ((im = XmlHelper.getAttribute(node, "init-method")) != null) {
            rrd.setInitMethod(im);
        }
        if ((dm = XmlHelper.getAttribute(node, "destroy-method")) != null) {
            rrd.setDestroyMethod(dm);
        }
        LinkedHashMap<Integer, Object> constructors = new LinkedHashMap<Integer, Object>();
        rrd.setConstructors(constructors);
        NodeList props = node.getChildNodes();
        int index = 0;
        for (int i = 0; i < props.getLength(); ++i) {
            Node child = props.item(i);
            if (!"argument".equals(child.getNodeName())) continue;
            String val = XmlHelper.getAttribute(child, "value");
            String ref = XmlHelper.getAttribute(child, "ref");
            if (val != null) {
                constructors.put(index++, this.extractValue(camelContext, val, false));
                continue;
            }
            if (ref == null) continue;
            constructors.put(index++, "#bean:" + this.extractValue(camelContext, ref, false));
        }
        if (!constructors.isEmpty()) {
            rrd.setConstructors(constructors);
        }
        LinkedHashMap<Object, String> properties = new LinkedHashMap<Object, String>();
        props = node.getChildNodes();
        for (int i = 0; i < props.getLength(); ++i) {
            Node child = props.item(i);
            if (!"property".equals(child.getNodeName())) continue;
            String key = XmlHelper.getAttribute(child, "name");
            String val = XmlHelper.getAttribute(child, "value");
            String ref = XmlHelper.getAttribute(child, "ref");
            if (key != null && val != null) {
                properties.put(key, this.extractValue(camelContext, val, false));
            } else if (key != null && ref != null) {
                properties.put(key, this.extractValue(camelContext, "#bean:" + ref, false));
            }
            for (Node n : BlueprintXmlBeansHandler.getChildNodes(child, "list")) {
                int j = 0;
                for (Node v : BlueprintXmlBeansHandler.getChildNodes(n, "value")) {
                    val = v.getTextContent();
                    if (key != null && val != null) {
                        String k = key + "[" + j + "]";
                        properties.put(k, this.extractValue(camelContext, val, false));
                    }
                    ++j;
                }
            }
            for (Node n : BlueprintXmlBeansHandler.getChildNodes(child, "map")) {
                for (Node v : BlueprintXmlBeansHandler.getChildNodes(n, "entry")) {
                    Object k = XmlHelper.getAttribute(v, "key");
                    val = XmlHelper.getAttribute(v, "value");
                    if (key == null || k == null || val == null) continue;
                    k = key + "[" + (String)k + "]";
                    properties.put(k, this.extractValue(camelContext, val, false));
                }
            }
        }
        if (!properties.isEmpty()) {
            rrd.setProperties(properties);
        }
        return rrd;
    }

    private static List<Node> getChildNodes(Node node, String name) {
        ArrayList<Node> answer = new ArrayList<Node>();
        NodeList list = node.getChildNodes();
        for (int j = 0; j < list.getLength(); ++j) {
            Node entry = list.item(j);
            if (!name.equals(entry.getNodeName())) continue;
            answer.add(entry);
        }
        return answer;
    }

    private void discoverBeans(CamelContext camelContext, String fileName, Document dom) {
        Resource resource = ((ResourceLoader)camelContext.getCamelContextExtension().getContextPlugin(ResourceLoader.class)).resolveResource("file:" + fileName);
        NodeList beans = dom.getElementsByTagName("bean");
        for (int i = 0; i < beans.getLength(); ++i) {
            String id;
            Node n = beans.item(i);
            if (!n.hasAttributes() || (id = XmlHelper.getAttribute(n, "id")) == null) continue;
            this.delayedBeans.put(id, n);
            this.resources.put(id, resource);
        }
    }

    protected String extractValue(CamelContext camelContext, String val, boolean resolve) {
        if (val != null && val.contains("${")) {
            Matcher matcher = BLUEPRINT_PATTERN.matcher(val);
            while (matcher.find()) {
                String replace = "{{" + matcher.group(1) + "}}";
                val = matcher.replaceFirst(replace);
                matcher.reset(val);
            }
        }
        if (resolve && camelContext != null) {
            val = camelContext.resolvePropertyPlaceholders(val);
        }
        return val;
    }

    private void registerAndCreateBean(CamelContext camelContext, RegistryBeanDefinition def, boolean delayIfFailed) {
        Object type = def.getType();
        String name = def.getName();
        if (name == null || name.isBlank()) {
            name = type;
        }
        if (type != null) {
            if (!((String)type).startsWith("#")) {
                type = "#class:" + (String)type;
            }
            try {
                if (def.getFactoryBean() != null && def.getFactoryMethod() != null) {
                    type = (String)type + "#" + def.getFactoryBean() + ":" + def.getFactoryMethod();
                } else if (def.getFactoryMethod() != null) {
                    type = (String)type + "#" + def.getFactoryMethod();
                }
                StringJoiner ctr = new StringJoiner(", ");
                if (def.getConstructors() != null && !def.getConstructors().isEmpty()) {
                    TreeMap sorted = new TreeMap(def.getConstructors());
                    for (Object val : sorted.values()) {
                        Object text = val.toString();
                        if (!StringHelper.isQuoted((String)text)) {
                            text = "\"" + (String)text + "\"";
                        }
                        ctr.add((CharSequence)text);
                    }
                    type = (String)type + "(" + String.valueOf(ctr) + ")";
                }
                Object target = PropertyBindingSupport.resolveBean((CamelContext)camelContext, (Object)type);
                if (def.getProperties() != null && !def.getProperties().isEmpty()) {
                    PropertyBindingSupport.setPropertiesOnTarget((CamelContext)camelContext, (Object)target, (Map)def.getProperties());
                }
                this.bindBean(camelContext, def, name, target);
            }
            catch (Exception e) {
                if (delayIfFailed) {
                    this.delayedRegistrations.add(def);
                }
                boolean ignore = PluginHelper.getRoutesLoader((CamelContext)camelContext).isIgnoreLoadingError();
                if (ignore) {
                    this.addBeanToCamelModel(camelContext, name, def);
                }
                LOG.warn("Error creating bean: {} due to: {}. This exception is ignored.", new Object[]{type, e.getMessage(), e});
            }
        }
    }

    protected void bindBean(CamelContext camelContext, RegistryBeanDefinition def, String name, Object target) throws Exception {
        this.destroyBean(name, true);
        camelContext.getRegistry().unbind(name);
        String initMethod = def.getInitMethod();
        if (initMethod != null) {
            ObjectHelper.invokeMethodSafe((String)initMethod, (Object)target, (Object[])new Object[0]);
        }
        camelContext.getRegistry().bind(name, target);
        if (def.getDestroyMethod() != null) {
            this.beansToDestroy.put(name, (KeyValueHolder<Object, String>)new KeyValueHolder(target, (Object)def.getDestroyMethod()));
        }
        this.addBeanToCamelModel(camelContext, name, def);
    }

    protected void addBeanToCamelModel(CamelContext camelContext, String name, RegistryBeanDefinition def) {
        Model model = (Model)camelContext.getCamelContextExtension().getContextPlugin(Model.class);
        if (model != null) {
            LOG.debug("Adding OSGi <blueprint> XML bean: {} to DSL model", (Object)name);
            model.addRegistryBean(def);
        }
    }

    protected void destroyBean(String name, boolean remove) {
        KeyValueHolder<Object, String> holder;
        KeyValueHolder<Object, String> keyValueHolder = holder = remove ? this.beansToDestroy.remove(name) : this.beansToDestroy.get(name);
        if (holder != null) {
            String destroyMethod = (String)holder.getValue();
            Object target = holder.getKey();
            try {
                ObjectHelper.invokeMethodSafe((String)destroyMethod, (Object)target, (Object[])new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Error invoking destroy method: {} on bean: {} due to: {}. This exception is ignored.", new Object[]{destroyMethod, target, e.getMessage(), e});
            }
        }
    }

    public void stop() {
        for (String name : this.beansToDestroy.keySet()) {
            this.destroyBean(name, false);
        }
        this.beansToDestroy.clear();
    }
}

