/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kameletreify;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.kameletreify.KameletReify;
import org.apache.camel.component.kameletreify.KameletReifyEndpoint;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

@org.apache.camel.spi.annotations.Component(value="kamelet-reify")
public class KameletReifyComponent
extends DefaultComponent {
    private static final AtomicInteger COUNTER = new AtomicInteger();

    public KameletReifyComponent() {
        this(null);
    }

    public KameletReifyComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String query;
        int idx = uri.indexOf(63);
        if (idx > -1) {
            query = uri.substring(idx + 1);
        } else {
            String encoded = UnsafeUriCharactersEncoder.encode((String)uri);
            URI u = new URI(encoded);
            query = u.getRawQuery();
        }
        Map queryParams = URISupport.parseQuery((String)query, (boolean)true);
        String scheme = StringHelper.before((String)remaining, (String)":");
        String path = StringHelper.after((String)remaining, (String)":");
        String newScheme = scheme + "-" + COUNTER.getAndIncrement();
        Component newComponent = KameletReify.newComponentInstance(this.getCamelContext(), scheme);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            boolean bound = PropertyBindingSupport.build().withConfigurer(newComponent.getComponentPropertyConfigurer()).withReference(true).withRemoveParameters(true).bind(this.getCamelContext(), (Object)newComponent, key, val);
            if (!bound) continue;
            queryParams.remove(key);
        }
        this.getCamelContext().addComponent(newScheme, newComponent);
        return new KameletReifyEndpoint(uri, this, URISupport.appendParametersToURI((String)(newScheme + ":" + path), (Map)queryParams));
    }

    public boolean useRawUri() {
        return true;
    }
}

