/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kamelet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.component.kamelet.Kamelet;
import org.apache.camel.component.kamelet.KameletConsumer;
import org.apache.camel.component.kamelet.KameletEndpoint;
import org.apache.camel.component.kamelet.KameletNotFoundException;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteTemplateLoaderListener;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.RouteTemplateHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="kamelet")
public class KameletComponent
extends DefaultComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(KameletComponent.class);
    private final LifecycleHandler lifecycleHandler = new LifecycleHandler();
    private final Map<String, KameletConsumer> consumers = new HashMap<String, KameletConsumer>();
    private final Map<String, Processor> kameletEips = new ConcurrentHashMap<String, Processor>();
    @Metadata(label="advanced", autowired=true)
    private RouteTemplateLoaderListener routeTemplateLoaderListener;
    private volatile int stateCounter;
    @Metadata(label="producer", defaultValue="true")
    private boolean block = true;
    @Metadata(label="producer", defaultValue="30000")
    private long timeout = 30000L;
    @Metadata
    private Map<String, Properties> templateProperties;
    @Metadata
    private Map<String, Properties> routeProperties;
    @Metadata(defaultValue="classpath:/kamelets")
    private String location = "classpath:/kamelets";

    public void addKameletEip(String key, Processor callback) {
        this.kameletEips.put(key, callback);
    }

    public Processor removeKameletEip(String key) {
        return this.kameletEips.remove(key);
    }

    public Processor getKameletEip(String key) {
        return this.kameletEips.get(key);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KameletEndpoint endpoint;
        String templateId = Kamelet.extractTemplateId(this.getCamelContext(), remaining, parameters);
        String routeId = Kamelet.extractRouteId(this.getCamelContext(), remaining, parameters);
        String loc = Kamelet.extractLocation(this.getCamelContext(), parameters);
        parameters.remove("templateId");
        parameters.remove("routeId");
        parameters.remove("location");
        if ("source".equals(remaining) || "sink".equals(remaining)) {
            endpoint = new KameletEndpoint(uri, this, templateId, routeId);
            endpoint.setBlock(this.block);
            endpoint.setTimeout(this.timeout);
            endpoint.setLocation(loc);
            this.setProperties((Endpoint)endpoint, parameters);
        } else {
            Properties props;
            endpoint = new KameletEndpoint(uri, this, templateId, routeId){

                protected void doInit() throws Exception {
                    super.doInit();
                    KameletComponent.this.lifecycleHandler.track(this);
                }
            };
            endpoint.setBlock(this.block);
            endpoint.setTimeout(this.timeout);
            endpoint.setLocation(loc);
            this.setProperties((Endpoint)endpoint, parameters);
            HashMap<String, Object> kameletProperties = new HashMap<String, Object>();
            if (this.templateProperties != null && (props = this.templateProperties.get(templateId)) != null) {
                props.stringPropertyNames().forEach(name -> kameletProperties.put((String)name, props.get(name)));
            }
            if (this.routeProperties != null && (props = this.routeProperties.get(routeId)) != null) {
                props.stringPropertyNames().forEach(name -> kameletProperties.put((String)name, props.get(name)));
            }
            if (kameletProperties.isEmpty()) {
                Kamelet.extractKameletProperties(this.getCamelContext(), kameletProperties, templateId, routeId);
            }
            kameletProperties.putAll(parameters);
            kameletProperties.put("templateId", templateId);
            kameletProperties.put("routeId", routeId);
            endpoint.setKameletProperties(kameletProperties);
            ((ModelCamelContext)this.getCamelContext().adapt(ModelCamelContext.class)).addRouteTemplateDefinitionConverter(templateId, Kamelet::templateToRoute);
        }
        return endpoint;
    }

    protected boolean resolveRawParameterValues() {
        return false;
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Map<String, Properties> getTemplateProperties() {
        return this.templateProperties;
    }

    public void setTemplateProperties(Map<String, Properties> templateProperties) {
        this.templateProperties = templateProperties;
    }

    public Map<String, Properties> getRouteProperties() {
        return this.routeProperties;
    }

    public void setRouteProperties(Map<String, Properties> routeProperties) {
        this.routeProperties = routeProperties;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public RouteTemplateLoaderListener getRouteTemplateLoaderListener() {
        return this.routeTemplateLoaderListener;
    }

    public void setRouteTemplateLoaderListener(RouteTemplateLoaderListener routeTemplateLoaderListener) {
        this.routeTemplateLoaderListener = routeTemplateLoaderListener;
    }

    int getStateCounter() {
        return this.stateCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(String key, KameletConsumer consumer) {
        Map<String, KameletConsumer> map = this.consumers;
        synchronized (map) {
            if (this.consumers.putIfAbsent(key, consumer) != null) {
                throw new IllegalArgumentException("Cannot add a 2nd consumer to the same endpoint: " + key + ". KameletEndpoint only allows one consumer.");
            }
            ++this.stateCounter;
            this.consumers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(String key, KameletConsumer consumer) {
        Map<String, KameletConsumer> map = this.consumers;
        synchronized (map) {
            this.consumers.remove(key, (Object)consumer);
            ++this.stateCounter;
            this.consumers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KameletConsumer getConsumer(String key, boolean block, long timeout) throws InterruptedException {
        Map<String, KameletConsumer> map = this.consumers;
        synchronized (map) {
            KameletConsumer answer = this.consumers.get(key);
            if (answer == null && block) {
                long rem;
                StopWatch watch = new StopWatch();
                while ((answer = this.consumers.get(key)) == null && (rem = timeout - watch.taken()) > 0L) {
                    this.consumers.wait(rem);
                }
            }
            return answer;
        }
    }

    protected void doInit() throws Exception {
        this.getCamelContext().addLifecycleStrategy((LifecycleStrategy)this.lifecycleHandler);
        if (this.getCamelContext().isRunAllowed()) {
            this.lifecycleHandler.setInitialized(true);
        }
        super.doInit();
    }

    protected void doShutdown() throws Exception {
        this.getCamelContext().getLifecycleStrategies().remove((Object)this.lifecycleHandler);
        ServiceHelper.stopAndShutdownService(this.consumers);
        this.consumers.clear();
        this.kameletEips.clear();
        super.doShutdown();
    }

    private class LifecycleHandler
    extends LifecycleStrategySupport {
        private final List<KameletEndpoint> endpoints = new ArrayList<KameletEndpoint>();
        private final AtomicBoolean initialized = new AtomicBoolean();

        public void createRouteForEndpoint(KameletEndpoint endpoint) throws Exception {
            String loc;
            ModelCamelContext context = (ModelCamelContext)KameletComponent.this.getCamelContext().adapt(ModelCamelContext.class);
            String templateId = endpoint.getTemplateId();
            String routeId = endpoint.getRouteId();
            String string = loc = endpoint.getLocation() != null ? endpoint.getLocation() : KameletComponent.this.getLocation();
            if (context.getRouteTemplateDefinition(templateId) == null && loc != null) {
                LOGGER.debug("Loading route template={} from {}", (Object)templateId, (Object)loc);
                RouteTemplateHelper.loadRouteTemplateFromLocation((CamelContext)KameletComponent.this.getCamelContext(), (RouteTemplateLoaderListener)KameletComponent.this.routeTemplateLoaderListener, (String)templateId, (String)loc);
            }
            LOGGER.debug("Creating route from template={} and id={}", (Object)templateId, (Object)routeId);
            try {
                boolean started;
                String id = context.addRouteFromTemplate(routeId, templateId, endpoint.getKameletProperties());
                RouteDefinition def = context.getRouteDefinition(id);
                ServiceStatus status = context.getRouteController().getRouteStatus(id);
                boolean bl = started = status != null && status.isStarted();
                if (!started) {
                    context.startRouteDefinitions(Collections.singletonList(def));
                }
                LOGGER.debug("Route with id={} created from template={}", (Object)id, (Object)templateId);
            }
            catch (Exception e) {
                throw new KameletNotFoundException(templateId, loc, e);
            }
        }

        public void onContextInitialized(CamelContext context) throws VetoCamelContextStartException {
            if (this.initialized.compareAndSet(false, true)) {
                for (KameletEndpoint endpoint : this.endpoints) {
                    try {
                        this.createRouteForEndpoint(endpoint);
                    }
                    catch (Exception e) {
                        throw new VetoCamelContextStartException("Failure creating route from template: " + endpoint.getTemplateId(), (Throwable)e, context);
                    }
                }
                this.endpoints.clear();
            }
        }

        public void setInitialized(boolean initialized) {
            this.initialized.set(initialized);
        }

        public void track(KameletEndpoint endpoint) {
            if (this.initialized.get()) {
                try {
                    this.createRouteForEndpoint(endpoint);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                }
            } else {
                LOGGER.debug("Tracking route template={} and id={}", (Object)endpoint.getTemplateId(), (Object)endpoint.getRouteId());
                this.endpoints.add(endpoint);
            }
        }
    }
}

