/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kamelet;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.kamelet.KameletComponent;
import org.apache.camel.component.kamelet.KameletConsumer;
import org.apache.camel.component.kamelet.KameletProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.8.0", scheme="kamelet", syntax="kamelet:templateId/routeId", title="Kamelet", lenientProperties=true, category={Category.CORE})
public class KameletEndpoint
extends DefaultEndpoint {
    private final String key;
    private final Map<String, Object> kameletProperties;
    @Metadata(required=true)
    @UriPath(description="The Route Template ID")
    private final String templateId;
    @Metadata(label="advanced")
    @UriPath(description="The Route ID", defaultValueNote="The ID will be auto-generated if not provided")
    private final String routeId;
    @Metadata(label="advanced")
    @UriParam(description="Location of the Kamelet to use which can be specified as a resource from file system, classpath etc. The location cannot use wildcards, and must refer to a file including extension, for example file:/etc/foo-kamelet.xml")
    private String location;
    @UriParam(label="producer,advanced", defaultValue="true")
    private boolean block = true;
    @UriParam(label="producer,advanced", defaultValue="30000")
    private long timeout = 30000L;
    @UriParam(label="producer,advanced", defaultValue="true")
    private boolean failIfNoConsumers = true;

    public KameletEndpoint(String uri, KameletComponent component, String templateId, String routeId) {
        super(uri, (Component)component);
        ObjectHelper.notNull((Object)templateId, (String)"template id");
        ObjectHelper.notNull((Object)routeId, (String)"route id");
        this.templateId = templateId;
        this.routeId = routeId;
        this.key = templateId + "/" + routeId;
        this.kameletProperties = new HashMap<String, Object>();
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isFailIfNoConsumers() {
        return this.failIfNoConsumers;
    }

    public void setFailIfNoConsumers(boolean failIfNoConsumers) {
        this.failIfNoConsumers = failIfNoConsumers;
    }

    public KameletComponent getComponent() {
        return (KameletComponent)super.getComponent();
    }

    public boolean isLenientProperties() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Map<String, Object> getKameletProperties() {
        return Collections.unmodifiableMap(this.kameletProperties);
    }

    public void setKameletProperties(Map<String, Object> kameletProperties) {
        if (kameletProperties != null) {
            this.kameletProperties.clear();
            this.kameletProperties.putAll(kameletProperties);
        }
    }

    public Producer createProducer() throws Exception {
        return new KameletProducer(this, this.key);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        KameletConsumer answer = new KameletConsumer(this, processor, this.key);
        this.configureConsumer((Consumer)answer);
        return answer;
    }
}

