/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kamelet;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kamelet.KameletComponent;
import org.apache.camel.component.kamelet.KameletConsumer;
import org.apache.camel.component.kamelet.KameletConsumerNotAvailableException;
import org.apache.camel.component.kamelet.KameletEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KameletProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KameletProducer.class);
    private volatile KameletConsumer consumer;
    private int stateCounter;
    private final KameletEndpoint endpoint;
    private final KameletComponent component;
    private final String key;
    private final boolean block;
    private final long timeout;

    public KameletProducer(KameletEndpoint endpoint, String key) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.component = endpoint.getComponent();
        this.key = key;
        this.block = endpoint.isBlock();
        this.timeout = endpoint.getTimeout();
    }

    public void process(Exchange exchange) throws Exception {
        if (this.consumer == null || this.stateCounter != this.component.getStateCounter()) {
            this.stateCounter = this.component.getStateCounter();
            this.consumer = this.component.getConsumer(this.key, this.block, this.timeout);
        }
        if (this.consumer == null) {
            if (this.endpoint.isFailIfNoConsumers()) {
                throw new KameletConsumerNotAvailableException("No consumers available on endpoint: " + (Object)((Object)this.endpoint), exchange);
            }
            LOG.debug("message ignored, no consumers available on endpoint: {}", (Object)this.endpoint);
        } else {
            this.consumer.getProcessor().process(exchange);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            if (this.consumer == null || this.stateCounter != this.component.getStateCounter()) {
                this.stateCounter = this.component.getStateCounter();
                this.consumer = this.component.getConsumer(this.key, this.block, this.timeout);
            }
            if (this.consumer == null) {
                if (this.endpoint.isFailIfNoConsumers()) {
                    exchange.setException((Throwable)((Object)new KameletConsumerNotAvailableException("No consumers available on endpoint: " + (Object)((Object)this.endpoint), exchange)));
                } else {
                    LOG.debug("message ignored, no consumers available on endpoint: {}", (Object)this.endpoint);
                }
                callback.done(true);
                return true;
            }
            return this.consumer.getAsyncProcessor().process(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }
}

