/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.http;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.knative.http.KnativeHttpHeaderFilterStrategy;
import org.apache.camel.component.knative.http.KnativeHttpSupport;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.apache.camel.component.knative.spi.KnativeTransportConfiguration;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnativeHttpConsumer
extends DefaultConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnativeHttpConsumer.class);
    private final KnativeTransportConfiguration configuration;
    private final Predicate<HttpServerRequest> filter;
    private final KnativeResource resource;
    private final Router router;
    private final HeaderFilterStrategy headerFilterStrategy;
    private String basePath;
    private Route route;
    private BigInteger maxBodySize;
    private boolean preallocateBodyBuffer;

    public KnativeHttpConsumer(KnativeTransportConfiguration configuration, Endpoint endpoint, KnativeResource resource, Router router, Processor processor) {
        super(endpoint, processor);
        this.configuration = configuration;
        this.resource = resource;
        this.router = router;
        this.headerFilterStrategy = new KnativeHttpHeaderFilterStrategy();
        this.filter = KnativeHttpSupport.createFilter(this.configuration.getCloudEvent(), resource);
        this.preallocateBodyBuffer = true;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public BigInteger getMaxBodySize() {
        return this.maxBodySize;
    }

    public void setMaxBodySize(BigInteger maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    public boolean isPreallocateBodyBuffer() {
        return this.preallocateBodyBuffer;
    }

    public void setPreallocateBodyBuffer(boolean preallocateBodyBuffer) {
        this.preallocateBodyBuffer = preallocateBodyBuffer;
    }

    protected void doStart() throws Exception {
        if (this.route == null) {
            Object path = this.resource.getPath();
            if (ObjectHelper.isEmpty((Object)path)) {
                path = "/";
            }
            if (ObjectHelper.isNotEmpty((Object)this.basePath)) {
                path = this.basePath + (String)path;
            }
            LOGGER.debug("Creating route for path: {}", path);
            this.route = this.router.route(HttpMethod.POST, (String)path);
            final BodyHandler bodyHandler = BodyHandler.create();
            bodyHandler.setPreallocateBodyBuffer(this.preallocateBodyBuffer);
            if (this.maxBodySize != null) {
                bodyHandler.setBodyLimit(this.maxBodySize.longValueExact());
            }
            this.route.handler((Handler)new Handler<RoutingContext>(){

                public void handle(RoutingContext event) {
                    event.request().resume();
                    bodyHandler.handle((Object)event);
                }
            });
            this.route.handler(routingContext -> {
                LOGGER.debug("Handling {}", routingContext);
                if (this.filter.test(routingContext.request())) {
                    this.handleRequest((RoutingContext)routingContext);
                } else {
                    LOGGER.debug("Cannot handle request on {}, next", (Object)this.getEndpoint().getEndpointUri());
                    routingContext.next();
                }
            });
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.route != null) {
            this.route.remove();
        }
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        if (this.route != null) {
            this.route.disable();
        }
    }

    protected void doResume() throws Exception {
        if (this.route != null) {
            this.route.enable();
        }
    }

    private void handleRequest(RoutingContext routingContext) {
        HttpServerRequest request = routingContext.request();
        Exchange exchange = this.getEndpoint().createExchange();
        Message message = this.toMessage(request, exchange);
        Buffer payload = routingContext.getBody();
        if (payload != null) {
            message.setBody((Object)payload.getBytes());
        } else {
            message.setBody(null);
        }
        routingContext.vertx().executeBlocking(promise -> {
            try {
                this.createUoW(exchange);
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
                return;
            }
            this.getAsyncProcessor().process(exchange, c -> {
                if (!exchange.isFailed()) {
                    promise.complete();
                } else {
                    promise.fail((Throwable)exchange.getException());
                }
            });
        }, false, result -> {
            try {
                Throwable failure;
                block12: {
                    failure = null;
                    if (result.succeeded()) {
                        try {
                            HttpServerResponse response = this.toHttpResponse(request, exchange.getMessage());
                            Buffer body = null;
                            if (request.response().getStatusCode() != 204 && this.configuration.isReply()) {
                                body = this.computeResponseBody(exchange.getMessage());
                                String contentType = MessageHelper.getContentType((Message)exchange.getMessage());
                                if (contentType != null) {
                                    response.putHeader("Content-Type", contentType);
                                }
                            }
                            if (body != null) {
                                request.response().end(body);
                                break block12;
                            }
                            request.response().setStatusCode(204);
                            request.response().end();
                        }
                        catch (Exception e) {
                            failure = e;
                        }
                    } else if (result.failed()) {
                        failure = result.cause();
                    }
                }
                if (failure != null) {
                    this.getExceptionHandler().handleException(failure);
                    routingContext.fail(failure);
                }
            }
            finally {
                this.doneUoW(exchange);
            }
        });
    }

    private Message toMessage(HttpServerRequest request, Exchange exchange) {
        Message message = exchange.getMessage();
        String path = request.path();
        if (this.resource.getPath() != null) {
            String match;
            String endpointPath = this.resource.getPath();
            String matchPath = path.toLowerCase(Locale.US);
            if (matchPath.startsWith(match = endpointPath.toLowerCase(Locale.US))) {
                path = path.substring(endpointPath.length());
            }
        }
        for (Map.Entry entry : request.headers().entries()) {
            if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            KnativeHttpSupport.appendHeader(message.getHeaders(), (String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : request.params().entries()) {
            if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            KnativeHttpSupport.appendHeader(message.getHeaders(), (String)entry.getKey(), entry.getValue());
        }
        message.setHeader("CamelHttpPath", (Object)path);
        message.setHeader("CamelHttpMethod", (Object)request.method());
        message.setHeader("CamelHttpUri", (Object)request.uri());
        message.setHeader("CamelHttpQuery", (Object)request.query());
        return message;
    }

    private HttpServerResponse toHttpResponse(HttpServerRequest request, Message message) {
        HttpServerResponse response = request.response();
        boolean failed = message.getExchange().isFailed();
        int defaultCode = failed ? 500 : 200;
        int code = (Integer)message.getHeader("CamelHttpResponseCode", (Object)defaultCode, Integer.TYPE);
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        response.setStatusCode(code);
        if (this.configuration.isReply()) {
            for (Map.Entry entry : message.getHeaders().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                for (Object it : org.apache.camel.support.ObjectHelper.createIterable(value, null)) {
                    String headerValue = (String)tc.convertTo(String.class, it);
                    if (headerValue == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, message.getExchange())) continue;
                    response.putHeader(key, headerValue);
                }
            }
            KnativeHttpSupport.remapCloudEventHeaders(this.configuration.getCloudEvent(), message);
            if (this.configuration.isRemoveCloudEventHeadersInReply()) {
                KnativeHttpSupport.removeCloudEventHeaders(this.configuration.getCloudEvent(), message);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer computeResponseBody(Message message) throws NoTypeConversionAvailableException {
        Object body = message.getBody();
        Exception exception = message.getExchange().getException();
        if (exception != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            try {
                exception.printStackTrace(pw);
                body = sw.toString().getBytes(StandardCharsets.UTF_8);
                message.setHeader("Content-Type", (Object)"text/plain");
                ExchangeHelper.setFailureHandled((Exchange)message.getExchange());
            }
            catch (Throwable throwable) {
                IOHelper.close((Closeable[])new Closeable[]{pw, sw});
                throw throwable;
            }
            IOHelper.close((Closeable[])new Closeable[]{pw, sw});
        }
        return body != null ? Buffer.buffer((byte[])((byte[])message.getExchange().getContext().getTypeConverter().mandatoryConvertTo(byte[].class, body))) : null;
    }
}

