/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.component.knative.http.KnativeHttpConsumer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="knative", displayName="Knative", description="Knative HTTP Service")
public class KnativeHttpConsole
extends AbstractDevConsole {
    public KnativeHttpConsole() {
        super("camel", "knative", "Knative", "Knative HTTP Service");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            String host = null;
            int port = -1;
            String path = null;
            try {
                Service service = this.getCamelContext().hasService(s -> s.getClass().getSimpleName().equals("MainHttpServer"));
                if (service != null) {
                    MBeanServer mBeanServer = this.getCamelContext().getManagementStrategy().getManagementAgent().getMBeanServer();
                    ObjectName on = this.getCamelContext().getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForService(this.getCamelContext(), service);
                    host = (String)mBeanServer.getAttribute(on, "Host");
                    port = (Integer)mBeanServer.getAttribute(on, "Port");
                    path = (String)mBeanServer.getAttribute(on, "Path");
                }
            }
            catch (Exception service) {
                // empty catch block
            }
            List<Consumer> list = this.getCamelContext().getRoutes().stream().map(Route::getConsumer).filter(c -> KnativeHttpConsumer.class.getName().equals(c.getClass().getName())).toList();
            for (Consumer c2 : list) {
                KnativeHttpConsumer knc = (KnativeHttpConsumer)c2;
                if (host != null) {
                    String p = path != null ? path + "/" + knc.getPath() : knc.getPath();
                    p = StringHelper.removeStartingCharacters((String)p, (char)'/');
                    sb.append(String.format("    %s://%s:%d/%s\n", "http", host, port, p));
                    continue;
                }
                sb.append(String.format("    %s://%s\n", "http", knc.getPath()));
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ManagedCamelContext mcc = (ManagedCamelContext)this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            String host = null;
            int port = -1;
            String path = null;
            try {
                Service service = this.getCamelContext().hasService(s -> s.getClass().getSimpleName().equals("MainHttpServer"));
                if (service != null) {
                    MBeanServer mBeanServer = this.getCamelContext().getManagementStrategy().getManagementAgent().getMBeanServer();
                    ObjectName on = this.getCamelContext().getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForService(this.getCamelContext(), service);
                    host = (String)mBeanServer.getAttribute(on, "Host");
                    port = (Integer)mBeanServer.getAttribute(on, "Port");
                    path = (String)mBeanServer.getAttribute(on, "Path");
                }
            }
            catch (Exception service) {
                // empty catch block
            }
            List<Consumer> list = this.getCamelContext().getRoutes().stream().map(Route::getConsumer).filter(c -> KnativeHttpConsumer.class.getName().equals(c.getClass().getName())).toList();
            ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
            for (Consumer c2 : list) {
                KnativeHttpConsumer knc = (KnativeHttpConsumer)c2;
                JsonObject jo = new JsonObject();
                jo.put((Object)"protocol", (Object)"http");
                if (host != null) {
                    jo.put((Object)"host", (Object)host);
                }
                if (port != -1) {
                    jo.put((Object)"port", (Object)port);
                }
                String p = path != null ? path + "/" + knc.getPath() : knc.getPath();
                p = StringHelper.removeStartingCharacters((String)p, (char)'/');
                jo.put((Object)"path", (Object)p);
                arr.add(jo);
            }
            if (!arr.isEmpty()) {
                root.put((Object)"consumers", arr);
            }
        }
        return root;
    }
}

