/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cloudevents.CloudEvent;
import org.apache.camel.component.cloudevents.CloudEvents;
import org.apache.camel.component.knative.KnativeComponent;
import org.apache.camel.component.knative.KnativeConfiguration;
import org.apache.camel.component.knative.KnativeProducer;
import org.apache.camel.component.knative.ce.CloudEventProcessor;
import org.apache.camel.component.knative.ce.CloudEventProcessors;
import org.apache.camel.component.knative.spi.Knative;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.apache.camel.component.knative.spi.KnativeTransportConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.15.0", scheme="knative", syntax="knative:type/typeId", title="Knative", category={Category.CLOUD})
public class KnativeEndpoint
extends DefaultEndpoint {
    private final CloudEvent cloudEvent;
    private final CloudEventProcessor cloudEventProcessor;
    @UriPath(description="The Knative resource type")
    private final Knative.Type type;
    @UriPath(description="The identifier of the Knative resource")
    private final String typeId;
    @UriParam
    private KnativeConfiguration configuration;

    public KnativeEndpoint(String uri, KnativeComponent component, Knative.Type type, String name, KnativeConfiguration configuration) {
        super(uri, (Component)component);
        this.type = type;
        this.typeId = name;
        this.configuration = configuration;
        this.cloudEvent = CloudEvents.fromSpecVersion((String)configuration.getCloudEventsSpecVersion());
        this.cloudEventProcessor = CloudEventProcessors.fromSpecVersion(configuration.getCloudEventsSpecVersion());
    }

    public KnativeComponent getComponent() {
        return (KnativeComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        KnativeResource service = this.lookupServiceDefinition(Knative.EndpointKind.sink);
        Processor ceProcessor = this.cloudEventProcessor.producer(this, service);
        Producer producer = this.getComponent().getProducerFactory().createProducer((Endpoint)this, this.createTransportConfiguration(service), service);
        PropertyBindingSupport.build().withCamelContext(this.getCamelContext()).withProperties(this.configuration.getTransportOptions()).withRemoveParameters(false).withMandatory(false).withTarget((Object)producer).bind();
        return new KnativeProducer((Endpoint)this, ceProcessor, new Processor[]{e -> e.getMessage().removeHeader("Host"), producer});
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        KnativeResource service = this.lookupServiceDefinition(Knative.EndpointKind.source);
        Processor ceProcessor = this.cloudEventProcessor.consumer(this, service);
        Processor replyProcessor = this.configuration.isReplyWithCloudEvent() ? this.cloudEventProcessor.producer(this, service) : null;
        ArrayList<Processor> list = new ArrayList<Processor>();
        list.add(ceProcessor);
        list.add(processor);
        if (replyProcessor != null) {
            list.add(replyProcessor);
        }
        ExtendedCamelContext ecc = (ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class);
        Processor pipeline = ecc.getProcessorFactory().createProcessor((CamelContext)ecc, "Pipeline", new Object[]{list});
        Consumer consumer = this.getComponent().getConsumerFactory().createConsumer((Endpoint)this, this.createTransportConfiguration(service), service, pipeline);
        PropertyBindingSupport.build().withCamelContext(this.getCamelContext()).withProperties(this.configuration.getTransportOptions()).withRemoveParameters(false).withMandatory(false).withTarget((Object)consumer).bind();
        this.configureConsumer(consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return true;
    }

    public Knative.Type getType() {
        return this.type;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public CloudEvent getCloudEvent() {
        return this.cloudEvent;
    }

    public KnativeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KnativeConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void doInit() {
        if (ObjectHelper.isEmpty((Object)this.configuration.getTypeId())) {
            this.configuration.setTypeId(this.typeId);
        }
    }

    KnativeResource lookupServiceDefinition(Knative.EndpointKind endpointKind) {
        String val;
        String key;
        String resourceName = this.type == Knative.Type.event && this.configuration.getName() != null ? this.configuration.getName() : this.configuration.getTypeId();
        KnativeResource resource = this.lookupServiceDefinition(resourceName, endpointKind).or(() -> this.lookupServiceDefinition("default", endpointKind)).orElseThrow(() -> new IllegalArgumentException(String.format("Unable to find a resource definition for %s/%s/%s", this.type, endpointKind, resourceName)));
        KnativeResource answer = KnativeResource.from((KnativeResource)resource);
        for (Map.Entry<String, String> entry : this.configuration.getFilters().entrySet()) {
            key = entry.getKey();
            val = entry.getValue();
            if (key.startsWith("filter.")) {
                key = key.substring("filter.".length());
            }
            answer.addFilter(key, val);
        }
        for (Map.Entry<String, String> entry : this.configuration.getCeOverride().entrySet()) {
            key = entry.getKey();
            val = entry.getValue();
            if (key.startsWith("ce.override.")) {
                key = key.substring("ce.override.".length());
            }
            answer.addCeOverride(key, val);
        }
        if (resource.getType() == Knative.Type.event && ObjectHelper.isNotEmpty((Object)this.configuration.getTypeId())) {
            answer.setCloudEventType(this.configuration.getTypeId());
            answer.addFilter("CamelCloudEventType", this.configuration.getTypeId());
        }
        return answer;
    }

    Optional<KnativeResource> lookupServiceDefinition(String name, Knative.EndpointKind endpointKind) {
        return this.servicesDefinitions().filter(definition -> definition.matches(this.type, name)).filter(KnativeEndpoint.serviceFilter(this.configuration, endpointKind)).findFirst();
    }

    private KnativeTransportConfiguration createTransportConfiguration(KnativeResource definition) {
        return new KnativeTransportConfiguration(this.cloudEventProcessor.cloudEvent(), !this.configuration.isReplyWithCloudEvent(), ((Boolean)ObjectHelper.supplyIfEmpty((Object)this.configuration.getReply(), () -> ((KnativeResource)definition).getReply())).booleanValue());
    }

    private Stream<KnativeResource> servicesDefinitions() {
        return Stream.concat(this.getCamelContext().getRegistry().findByType(KnativeResource.class).stream(), this.configuration.getEnvironment().stream());
    }

    private static Predicate<KnativeResource> serviceFilter(KnativeConfiguration configuration, Knative.EndpointKind endpointKind) {
        return resource -> {
            if (!Objects.equals(endpointKind, resource.getEndpointKind())) {
                return false;
            }
            if (configuration.getApiVersion() != null && !Objects.equals(resource.getObjectApiVersion(), configuration.getApiVersion())) {
                return false;
            }
            if (configuration.getKind() != null && !Objects.equals(resource.getObjectKind(), configuration.getKind())) {
                return false;
            }
            return configuration.getName() == null || Objects.equals(resource.getObjectName(), configuration.getName());
        };
    }
}

