/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.service.ServiceHelper;

public class KnativeProducer
extends DefaultAsyncProducer {
    final AsyncProcessor processor;

    public KnativeProducer(Endpoint endpoint, Processor processor, Processor ... processors) throws Exception {
        super(endpoint);
        ArrayList<Processor> elements = new ArrayList<Processor>(1 + processors.length);
        elements.add(processor);
        Collections.addAll(elements, processors);
        CamelContext ecc = this.getEndpoint().getCamelContext();
        Processor pipeline = ecc.getCamelContextExtension().getProcessorFactory().createProcessor(ecc, "Pipeline", new Object[]{elements});
        this.processor = AsyncProcessorConverterHelper.convert((Processor)pipeline);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.processor.process(exchange, callback);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }

    protected void doSuspend() throws Exception {
        ServiceHelper.suspendService((Object)this.processor);
    }

    protected void doResume() throws Exception {
        ServiceHelper.resumeService((Object)this.processor);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService((Object)this.processor);
    }
}

