/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cloudevents.CloudEvents;
import org.apache.camel.component.knative.spi.KnativeEnvironment;
import org.apache.camel.component.knative.spi.KnativeSinkBinding;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class KnativeConfiguration
implements Cloneable {
    @UriParam
    private KnativeEnvironment environment;
    @UriParam
    private KnativeSinkBinding sinkBinding;
    @UriParam
    private String typeId;
    @UriParam(defaultValue="1.0", enums="1.0,1.0.1,1.0.2")
    private String cloudEventsSpecVersion = CloudEvents.v1_0.version();
    @UriParam(defaultValue="org.apache.camel.event")
    private String cloudEventsType = "org.apache.camel.event";
    @UriParam(prefix="transport.")
    private Map<String, Object> transportOptions;
    @UriParam(prefix="filter.")
    private Map<String, String> filters;
    @UriParam(prefix="ce.override.")
    private Map<String, String> ceOverride;
    @UriParam(label="advanced")
    private String apiVersion;
    @UriParam(label="advanced")
    private String kind;
    @UriParam(label="advanced")
    private String name;
    @UriParam(label="consumer", defaultValue="false")
    private boolean replyWithCloudEvent;
    @UriParam(label="consumer,advanced", defaultValue="true")
    private Boolean reply;

    public KnativeEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(KnativeEnvironment environment) {
        this.environment = environment;
    }

    public KnativeSinkBinding getSinkBinding() {
        return this.sinkBinding;
    }

    public void setSinkBinding(KnativeSinkBinding sinkBinding) {
        this.sinkBinding = sinkBinding;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public boolean isReplyWithCloudEvent() {
        return this.replyWithCloudEvent;
    }

    public void setReplyWithCloudEvent(boolean replyWithCloudEvent) {
        this.replyWithCloudEvent = replyWithCloudEvent;
    }

    public String getCloudEventsSpecVersion() {
        return this.cloudEventsSpecVersion;
    }

    public void setCloudEventsSpecVersion(String cloudEventsSpecVersion) {
        this.cloudEventsSpecVersion = cloudEventsSpecVersion;
    }

    public String getCloudEventsType() {
        return this.cloudEventsType;
    }

    public void setCloudEventsType(String cloudEventsType) {
        this.cloudEventsType = cloudEventsType;
    }

    public Map<String, Object> getTransportOptions() {
        return this.transportOptions;
    }

    public void setTransportOptions(Map<String, Object> transportOptions) {
        this.transportOptions = new HashMap<String, Object>(transportOptions);
    }

    public void addTransportOptions(String key, Object value) {
        if (this.transportOptions == null) {
            this.transportOptions = new HashMap<String, Object>();
        }
        this.transportOptions.put(key, value);
    }

    public Map<String, String> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, String> filters) {
        this.filters = new HashMap<String, String>(filters);
    }

    public Map<String, String> getCeOverride() {
        return this.ceOverride;
    }

    public void setCeOverride(Map<String, String> ceOverride) {
        this.ceOverride = new HashMap<String, String>(ceOverride);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getReply() {
        return this.reply;
    }

    public void setReply(Boolean reply) {
        this.reply = reply;
    }

    public KnativeConfiguration copy() {
        try {
            return (KnativeConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

