/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.config_maps;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.consumer.common.ConfigMapEvent;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;

public class KubernetesConfigMapsConsumer
extends DefaultConsumer {
    private final Processor processor;
    private ExecutorService executor;
    private ConfigMapsConsumerTask configMapWatcher;

    public KubernetesConfigMapsConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.configMapWatcher = new ConfigMapsConsumerTask();
        this.executor.submit(this.configMapWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.log.debug("Stopping Kubernetes ConfigMap Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                if (this.configMapWatcher != null) {
                    this.configMapWatcher.getWatch().close();
                }
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                if (this.configMapWatcher != null) {
                    this.configMapWatcher.getWatch().close();
                }
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class ConfigMapsConsumerTask
    implements Runnable {
        private Watch watch;

        ConfigMapsConsumerTask() {
        }

        @Override
        public void run() {
            FilterWatchListDeletable w = null;
            if (ObjectHelper.isNotEmpty((Object)KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((Object)KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w = (FilterWatchListDeletable)KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesClient().configMaps().withLabel(KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            if (ObjectHelper.isNotEmpty((Object)KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName())) {
                w = (FilterWatchListDeletable)KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesClient().configMaps().withName(KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName());
            }
            this.watch = (Watch)w.watch((Object)new Watcher<ConfigMap>(){

                public void eventReceived(Watcher.Action action, ConfigMap resource) {
                    ConfigMapEvent de = new ConfigMapEvent(action, resource);
                    Exchange exchange = KubernetesConfigMapsConsumer.this.getEndpoint().createExchange();
                    exchange.getIn().setBody((Object)de.getConfigMap());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)de.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesConfigMapsConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesConfigMapsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                }

                public void onClose(KubernetesClientException cause) {
                    if (cause != null) {
                        KubernetesConfigMapsConsumer.this.log.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

