/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.nodes;

import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeBuilder;
import io.fabric8.kubernetes.api.model.NodeFluent;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.NodeSpec;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesNodesProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesNodesProducer.class);

    public KubernetesNodesProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listNodes": {
                this.doList(exchange, operation);
                break;
            }
            case "listNodesByLabels": {
                this.doListNodesByLabels(exchange, operation);
                break;
            }
            case "getNode": {
                this.doGetNode(exchange, operation);
                break;
            }
            case "createNode": {
                this.doCreateNode(exchange, operation);
                break;
            }
            case "deleteNode": {
                this.doDeleteNode(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        NodeList nodeList = (NodeList)this.getEndpoint().getKubernetesClient().nodes().list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)nodeList.getItems());
    }

    protected void doListNodesByLabels(Exchange exchange, String operation) throws Exception {
        NodeList nodeList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesNodesLabels", Map.class);
        NonNamespaceOperation nodes = this.getEndpoint().getKubernetesClient().nodes();
        for (Map.Entry entry : labels.entrySet()) {
            nodes.withLabel((String)entry.getKey(), (String)entry.getValue());
        }
        nodeList = (NodeList)nodes.list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)nodeList.getItems());
    }

    protected void doGetNode(Exchange exchange, String operation) throws Exception {
        Node node = null;
        String pvName = (String)exchange.getIn().getHeader("CamelKubernetesNodeName", String.class);
        if (ObjectHelper.isEmpty((Object)pvName)) {
            LOG.error("Get a specific Node require specify a Node name");
            throw new IllegalArgumentException("Get a specific Node require specify a Node name");
        }
        node = (Node)((Resource)this.getEndpoint().getKubernetesClient().nodes().withName(pvName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)node);
    }

    protected void doCreateNode(Exchange exchange, String operation) throws Exception {
        Node node = null;
        String nodeName = (String)exchange.getIn().getHeader("CamelKubernetesNodeName", String.class);
        NodeSpec nodeSpec = (NodeSpec)exchange.getIn().getHeader("CamelKubernetesNodeSpec", NodeSpec.class);
        if (ObjectHelper.isEmpty((Object)nodeName)) {
            LOG.error("Create a specific node require specify a node name");
            throw new IllegalArgumentException("Create a specific node require specify a node name");
        }
        if (ObjectHelper.isEmpty((Object)nodeSpec)) {
            LOG.error("Create a specific node require specify a node spec bean");
            throw new IllegalArgumentException("Create a specific node require specify a node spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesPodsLabels", Map.class);
        Node nodeCreating = ((NodeBuilder)((NodeBuilder)((NodeFluent.MetadataNested)((NodeFluent.MetadataNested)new NodeBuilder().withNewMetadata().withName(nodeName)).withLabels(labels)).endMetadata()).withSpec(nodeSpec)).build();
        node = (Node)this.getEndpoint().getKubernetesClient().nodes().create((Object)nodeCreating);
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)node);
    }

    protected void doDeleteNode(Exchange exchange, String operation) throws Exception {
        String nodeName = (String)exchange.getIn().getHeader("CamelKubernetesNodeName", String.class);
        if (ObjectHelper.isEmpty((Object)nodeName)) {
            LOG.error("Deleting a specific Node require specify a Node name");
            throw new IllegalArgumentException("Deleting a specific Node require specify a Node name");
        }
        boolean nodeDeleted = ((Resource)this.getEndpoint().getKubernetesClient().nodes().withName(nodeName)).delete();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)nodeDeleted);
    }
}

