/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.replication_controllers;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesReplicationControllersProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesReplicationControllersProducer.class);

    public KubernetesReplicationControllersProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listReplicationControllers": {
                this.doList(exchange, operation);
                break;
            }
            case "listReplicationControllersByLabels": {
                this.doListReplicationControllersByLabels(exchange, operation);
                break;
            }
            case "getReplicationController": {
                this.doGetReplicationController(exchange, operation);
                break;
            }
            case "createReplicationController": {
                this.doCreateReplicationController(exchange, operation);
                break;
            }
            case "deleteReplicationController": {
                this.doDeleteReplicationController(exchange, operation);
                break;
            }
            case "scaleReplicationController": {
                this.doScaleReplicationController(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) {
        ReplicationControllerList rcList = null;
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        rcList = !ObjectHelper.isEmpty((Object)namespaceName) ? (ReplicationControllerList)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).list() : (ReplicationControllerList)((FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().replicationControllers().inAnyNamespace()).list();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)rcList.getItems());
    }

    protected void doListReplicationControllersByLabels(Exchange exchange, String operation) {
        ReplicationControllerList rcList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesReplicationControllersLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((Object)namespaceName)) {
            NonNamespaceOperation replicationControllers = (NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName);
            for (Map.Entry entry : labels.entrySet()) {
                replicationControllers.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            rcList = (ReplicationControllerList)replicationControllers.list();
        } else {
            FilterWatchListMultiDeletable replicationControllers = (FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().replicationControllers().inAnyNamespace();
            for (Map.Entry entry : labels.entrySet()) {
                replicationControllers.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            rcList = (ReplicationControllerList)replicationControllers.list();
        }
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)rcList.getItems());
    }

    protected void doGetReplicationController(Exchange exchange, String operation) throws Exception {
        ReplicationController rc = null;
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)rcName)) {
            LOG.error("Get a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Get a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Get a specific replication controller require specify a namespace name");
        }
        rc = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).withName(rcName)).get();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)rc);
    }

    protected void doCreateReplicationController(Exchange exchange, String operation) throws Exception {
        ReplicationController rc = null;
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ReplicationControllerSpec rcSpec = (ReplicationControllerSpec)exchange.getIn().getHeader("CamelKubernetesReplicationControllerSpec", ReplicationControllerSpec.class);
        if (ObjectHelper.isEmpty((Object)rcName)) {
            LOG.error("Create a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Create a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Create a specific replication controller require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)rcSpec)) {
            LOG.error("Create a specific replication controller require specify a replication controller spec bean");
            throw new IllegalArgumentException("Create a specific replication controller require specify a replication controller spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesReplicationControllersLabels", Map.class);
        ReplicationController rcCreating = ((ReplicationControllerBuilder)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName(rcName)).withLabels(labels)).endMetadata()).withSpec(rcSpec)).build();
        rc = (ReplicationController)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).create((Object)rcCreating);
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)rc);
    }

    protected void doDeleteReplicationController(Exchange exchange, String operation) throws Exception {
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)rcName)) {
            LOG.error("Delete a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Delete a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific replication controller require specify a namespace name");
        }
        boolean rcDeleted = ((RollableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).withName(rcName)).delete();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)rcDeleted);
    }

    protected void doScaleReplicationController(Exchange exchange, String operation) throws Exception {
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        Integer replicasNumber = (Integer)exchange.getIn().getHeader("CamelKubernetesReplicationControllerReplicas", Integer.class);
        if (ObjectHelper.isEmpty((Object)rcName)) {
            LOG.error("Scale a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Scale a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Scale a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Scale a specific replication controller require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)replicasNumber)) {
            LOG.error("Scale a specific replication controller require specify a replicas number");
            throw new IllegalArgumentException("Scale a specific replication controller require specify a replicas number");
        }
        ReplicationController rcScaled = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).withName(rcName)).scale(replicasNumber.intValue(), false);
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
        exchange.getOut().setBody((Object)rcScaled.getStatus().getReplicas());
    }
}

