/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.customresources;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.RawCustomResourceOperationsImpl;
import java.io.IOException;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCustomResourcesProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesCustomResourcesProducer.class);

    public KubernetesCustomResourcesProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange);
        String namespace = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getNamespace()) ? (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class) : this.getEndpoint().getKubernetesConfiguration().getNamespace();
        if (ObjectHelper.isEmpty((Object)namespace)) {
            throw new IllegalArgumentException("Custom Resource producer requires a namespace argument");
        }
        switch (operation) {
            case "listCustomResources": {
                this.doList(exchange, namespace);
                break;
            }
            case "listCustomResourcesByLabels": {
                this.doListByLabels(exchange, namespace);
                break;
            }
            case "getCustomResource": {
                this.doGet(exchange, namespace);
                break;
            }
            case "deleteCustomResource": {
                this.doDelete(exchange, namespace);
                break;
            }
            case "createCustomResource": {
                this.doCreate(exchange, namespace);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String namespaceName) {
        CustomResourceDefinitionContext context = this.getCRDContext(exchange.getIn());
        Map labels = this.getEndpoint().getKubernetesClient().customResource(context).list(namespaceName);
        JsonObject customResourcesListJSON = new JsonObject(labels);
        if (LOG.isDebugEnabled()) {
            LOG.debug(customResourcesListJSON.toString());
        }
        JsonArray customResourcesListItems = customResourcesListJSON.getCollection("items") != null ? new JsonArray(customResourcesListJSON.getCollection("items")) : new JsonArray();
        KubernetesHelper.prepareOutboundMessage(exchange, customResourcesListItems);
    }

    protected void doListByLabels(Exchange exchange, String namespaceName) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesCRDLabels", Map.class);
        JsonObject customResourcesListJSON = new JsonObject(this.getEndpoint().getKubernetesClient().customResource(this.getCRDContext(exchange.getIn())).list(namespaceName, labels));
        if (LOG.isDebugEnabled()) {
            LOG.debug(customResourcesListJSON.toString());
        }
        JsonArray customResourcesListItems = new JsonArray(customResourcesListJSON.getCollection("items"));
        KubernetesHelper.prepareOutboundMessage(exchange, customResourcesListItems);
    }

    protected void doGet(Exchange exchange, String namespaceName) {
        String customResourceName = (String)exchange.getIn().getHeader("CamelKubernetesCRDInstanceName", String.class);
        if (ObjectHelper.isEmpty((Object)customResourceName)) {
            throw new IllegalArgumentException("Get a specific Deployment require specify a Deployment name");
        }
        JsonObject customResourceJSON = new JsonObject();
        try {
            customResourceJSON = new JsonObject(this.getEndpoint().getKubernetesClient().customResource(this.getCRDContext(exchange.getIn())).get(namespaceName, customResourceName));
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 404) {
                LOG.info("Custom resource instance not found", (Throwable)e);
            }
            throw e;
        }
        KubernetesHelper.prepareOutboundMessage(exchange, customResourceJSON);
    }

    protected void doDelete(Exchange exchange, String namespaceName) throws IOException {
        String customResourceName = (String)exchange.getIn().getHeader("CamelKubernetesCRDInstanceName", String.class);
        if (ObjectHelper.isEmpty((Object)customResourceName)) {
            LOG.error("Deleting a specific deployment require specify a deployment name");
            throw new IllegalArgumentException("Deleting a specific deployment require specify a deployment name");
        }
        try {
            RawCustomResourceOperationsImpl raw = this.getEndpoint().getKubernetesClient().customResource(this.getCRDContext(exchange.getIn()));
            boolean deleted = raw.inNamespace(namespaceName).withName(customResourceName).delete();
            exchange.getMessage().setHeader("CamelKubernetesDeleteResult", (Object)deleted);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 404) {
                LOG.info("Custom resource instance not found", (Throwable)e);
            }
            throw e;
        }
    }

    protected void doCreate(Exchange exchange, String namespaceName) throws IOException {
        String customResourceInstance = (String)exchange.getIn().getHeader("CamelKubernetesCRDInstance", String.class);
        JsonObject gitHubSourceJSON = new JsonObject();
        try {
            Map customResource = this.getEndpoint().getKubernetesClient().customResource(this.getCRDContext(exchange.getIn())).inNamespace(namespaceName).create(customResourceInstance);
            gitHubSourceJSON = new JsonObject(customResource);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 409) {
                LOG.info("Custom resource instance already exists", (Throwable)e);
            }
            throw e;
        }
        KubernetesHelper.prepareOutboundMessage(exchange, gitHubSourceJSON);
    }

    private CustomResourceDefinitionContext getCRDContext(Message message) {
        String name = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getCrdName()) ? (String)message.getHeader("CamelKubernetesCRDName", String.class) : this.getEndpoint().getKubernetesConfiguration().getCrdName();
        String group = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getCrdGroup()) ? (String)message.getHeader("CamelKubernetesCRDGroup", String.class) : this.getEndpoint().getKubernetesConfiguration().getCrdGroup();
        String scope = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getCrdScope()) ? (String)message.getHeader("CamelKubernetesCRDScope", String.class) : this.getEndpoint().getKubernetesConfiguration().getCrdScope();
        String version = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getCrdVersion()) ? (String)message.getHeader("CamelKubernetesCRDVersion", String.class) : this.getEndpoint().getKubernetesConfiguration().getCrdVersion();
        String plural = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getCrdPlural()) ? (String)message.getHeader("CamelKubernetesCRDPlural", String.class) : this.getEndpoint().getKubernetesConfiguration().getCrdPlural();
        if (ObjectHelper.isEmpty((Object)name) || ObjectHelper.isEmpty((Object)group) || ObjectHelper.isEmpty((Object)scope) || ObjectHelper.isEmpty((Object)version) || ObjectHelper.isEmpty((Object)plural)) {
            LOG.error("one of more of the custom resource definition argument(s) are missing.");
            throw new IllegalArgumentException("one of more of the custom resource definition argument(s) are missing.");
        }
        return new CustomResourceDefinitionContext.Builder().withName((String)message.getHeader("CamelKubernetesCRDName", String.class)).withGroup((String)message.getHeader("CamelKubernetesCRDGroup", String.class)).withScope((String)message.getHeader("CamelKubernetesCRDScope", String.class)).withVersion((String)message.getHeader("CamelKubernetesCRDVersion", String.class)).withPlural((String)message.getHeader("CamelKubernetesCRDPlural", String.class)).build();
    }
}

