/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.persistent_volumes;

import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPersistentVolumesProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesPersistentVolumesProducer.class);

    public KubernetesPersistentVolumesProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listPersistentVolumes": {
                this.doList(exchange);
                break;
            }
            case "listPersistentVolumesByLabels": {
                this.doListPersistentVolumesByLabels(exchange);
                break;
            }
            case "getPersistentVolume": {
                this.doGetPersistentVolume(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        PersistentVolumeList persistentVolumeList = (PersistentVolumeList)this.getEndpoint().getKubernetesClient().persistentVolumes().list();
        KubernetesHelper.prepareOutboundMessage(exchange, persistentVolumeList.getItems());
    }

    protected void doListPersistentVolumesByLabels(Exchange exchange) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesPersistentVolumesLabels", Map.class);
        PersistentVolumeList pvList = (PersistentVolumeList)((FilterWatchListDeletable)this.getEndpoint().getKubernetesClient().persistentVolumes().withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, pvList.getItems());
    }

    protected void doGetPersistentVolume(Exchange exchange) {
        PersistentVolume pv = null;
        String pvName = (String)exchange.getIn().getHeader("CamelKubernetesPersistentVolumeName", String.class);
        if (ObjectHelper.isEmpty((Object)pvName)) {
            LOG.error("Get a specific Persistent Volume require specify a Persistent Volume name");
            throw new IllegalArgumentException("Get a specific Persistent Volume require specify a Persistent Volume name");
        }
        pv = (PersistentVolume)((Resource)this.getEndpoint().getKubernetesClient().persistentVolumes().withName(pvName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, pv);
    }
}

