/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.replication_controllers;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.component.kubernetes.consumer.common.ReplicationControllerEvent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesReplicationControllersConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesReplicationControllersConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private ReplicationControllersConsumerTask rcWatcher;

    public KubernetesReplicationControllersConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.rcWatcher = new ReplicationControllersConsumerTask();
        this.executor.submit(this.rcWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Replication Controllers Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.rcWatcher, this.rcWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class ReplicationControllersConsumerTask
    implements Runnable {
        private Watch watch;

        ReplicationControllersConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation w = KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesClient().replicationControllers();
            ObjectHelper.ifNotEmpty((Object)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace(), arg_0 -> ((MixedOperation)w).inNamespace(arg_0));
            if (ObjectHelper.isNotEmpty((Object)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((Object)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            ObjectHelper.ifNotEmpty((Object)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName(), arg_0 -> ((MixedOperation)w).withName(arg_0));
            this.watch = w.watch((Object)new Watcher<ReplicationController>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived(Watcher.Action action, ReplicationController resource) {
                    ReplicationControllerEvent rce = new ReplicationControllerEvent(action, resource);
                    Exchange exchange = KubernetesReplicationControllersConsumer.this.createExchange(false);
                    exchange.getIn().setBody((Object)rce.getReplicationController());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)rce.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesReplicationControllersConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesReplicationControllersConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                    finally {
                        KubernetesReplicationControllersConsumer.this.releaseExchange(exchange, false);
                    }
                }

                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

