/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.replication_controllers;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesReplicationControllersProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesReplicationControllersProducer.class);

    public KubernetesReplicationControllersProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listReplicationControllers": {
                this.doList(exchange);
                break;
            }
            case "listReplicationControllersByLabels": {
                this.doListReplicationControllersByLabels(exchange);
                break;
            }
            case "getReplicationController": {
                this.doGetReplicationController(exchange);
                break;
            }
            case "createReplicationController": {
                this.doCreateReplicationController(exchange);
                break;
            }
            case "deleteReplicationController": {
                this.doDeleteReplicationController(exchange);
                break;
            }
            case "scaleReplicationController": {
                this.doScaleReplicationController(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        ReplicationControllerList rcList = null;
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        rcList = !ObjectHelper.isEmpty((Object)namespaceName) ? (ReplicationControllerList)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).list() : (ReplicationControllerList)((FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().replicationControllers().inAnyNamespace()).list();
        KubernetesHelper.prepareOutboundMessage(exchange, rcList.getItems());
    }

    protected void doListReplicationControllersByLabels(Exchange exchange) {
        ReplicationControllerList rcList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesReplicationControllersLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((Object)namespaceName)) {
            NonNamespaceOperation replicationControllers = (NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName);
            rcList = (ReplicationControllerList)((FilterWatchListDeletable)replicationControllers.withLabels(labels)).list();
        } else {
            FilterWatchListMultiDeletable replicationControllers = (FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().replicationControllers().inAnyNamespace();
            rcList = (ReplicationControllerList)((FilterWatchListDeletable)replicationControllers.withLabels(labels)).list();
        }
        KubernetesHelper.prepareOutboundMessage(exchange, rcList.getItems());
    }

    protected void doGetReplicationController(Exchange exchange) {
        ReplicationController rc = null;
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)rcName)) {
            LOG.error("Get a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Get a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Get a specific replication controller require specify a namespace name");
        }
        rc = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).withName(rcName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, rc);
    }

    protected void doCreateReplicationController(Exchange exchange) {
        ReplicationController rc = null;
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ReplicationControllerSpec rcSpec = (ReplicationControllerSpec)exchange.getIn().getHeader("CamelKubernetesReplicationControllerSpec", ReplicationControllerSpec.class);
        if (ObjectHelper.isEmpty((Object)rcName)) {
            LOG.error("Create a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Create a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Create a specific replication controller require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)rcSpec)) {
            LOG.error("Create a specific replication controller require specify a replication controller spec bean");
            throw new IllegalArgumentException("Create a specific replication controller require specify a replication controller spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesReplicationControllersLabels", Map.class);
        ReplicationController rcCreating = ((ReplicationControllerBuilder)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName(rcName)).withLabels(labels)).endMetadata()).withSpec(rcSpec)).build();
        rc = (ReplicationController)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).create((Object)rcCreating);
        KubernetesHelper.prepareOutboundMessage(exchange, rc);
    }

    protected void doDeleteReplicationController(Exchange exchange) {
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)rcName)) {
            LOG.error("Delete a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Delete a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific replication controller require specify a namespace name");
        }
        boolean rcDeleted = ((RollableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).withName(rcName)).delete();
        KubernetesHelper.prepareOutboundMessage(exchange, rcDeleted);
    }

    protected void doScaleReplicationController(Exchange exchange) {
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        Integer replicasNumber = (Integer)exchange.getIn().getHeader("CamelKubernetesReplicationControllerReplicas", Integer.class);
        if (ObjectHelper.isEmpty((Object)rcName)) {
            LOG.error("Scale a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Scale a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Scale a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Scale a specific replication controller require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)replicasNumber)) {
            LOG.error("Scale a specific replication controller require specify a replicas number");
            throw new IllegalArgumentException("Scale a specific replication controller require specify a replicas number");
        }
        ReplicationController rcScaled = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).withName(rcName)).scale(replicasNumber.intValue(), false);
        KubernetesHelper.prepareOutboundMessage(exchange, rcScaled.getStatus().getReplicas());
    }
}

