/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cluster.lock.impl;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.apache.camel.component.kubernetes.cluster.lock.KubernetesLeaseResourceManager;
import org.apache.camel.component.kubernetes.cluster.lock.LeaderInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapLeaseResourceManager
implements KubernetesLeaseResourceManager<ConfigMap> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigMapLeaseResourceManager.class);
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssX";
    private static final String LEADER_PREFIX = "leader.pod.";
    private static final String LOCAL_TIMESTAMP_PREFIX = "leader.local.timestamp.";

    @Override
    public LeaderInfo decodeLeaderInfo(ConfigMap configMap, Set<String> members, String group) {
        return new LeaderInfo(group, ConfigMapLeaseResourceManager.getLeader(configMap, group), ConfigMapLeaseResourceManager.getLocalTimestamp(configMap, group), members, null);
    }

    @Override
    public ConfigMap fetchLeaseResource(KubernetesClient client, String namespace, String name, String group) {
        return (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(name)).get();
    }

    @Override
    public ConfigMap optimisticDeleteLeaderInfo(KubernetesClient client, ConfigMap leaseResource, String group) {
        ConfigMap updatedConfigMap = ConfigMapLeaseResourceManager.getConfigMapWithoutLeader(leaseResource, group);
        return (ConfigMap)((ReplaceDeletable)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(leaseResource.getMetadata().getNamespace())).withName(leaseResource.getMetadata().getName())).lockResourceVersion(leaseResource.getMetadata().getResourceVersion())).replace((Object)updatedConfigMap);
    }

    @Override
    public ConfigMap optimisticAcquireLeadership(KubernetesClient client, ConfigMap leaseResource, LeaderInfo newLeaderInfo) {
        ConfigMap updatedConfigMap = ConfigMapLeaseResourceManager.getConfigMapWithNewLeader(leaseResource, newLeaderInfo);
        return (ConfigMap)((ReplaceDeletable)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(leaseResource.getMetadata().getNamespace())).withName(leaseResource.getMetadata().getName())).lockResourceVersion(leaseResource.getMetadata().getResourceVersion())).replace((Object)updatedConfigMap);
    }

    @Override
    public ConfigMap createNewLeaseResource(KubernetesClient client, String namespace, String leaseResourceName, LeaderInfo leaderInfo) {
        ConfigMap newConfigMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(leaseResourceName)).addToLabels("provider", "camel")).addToLabels("kind", "locks")).endMetadata()).addToData(LEADER_PREFIX + leaderInfo.getGroupName(), leaderInfo.getLeader())).addToData(LOCAL_TIMESTAMP_PREFIX + leaderInfo.getGroupName(), ConfigMapLeaseResourceManager.formatDate(leaderInfo.getLocalTimestamp()))).build();
        return (ConfigMap)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).create((Object)newConfigMap);
    }

    @Override
    public ConfigMap refreshLeaseRenewTime(KubernetesClient client, ConfigMap leaseResource, int minUpdateIntervalSeconds) {
        return leaseResource;
    }

    private static ConfigMap getConfigMapWithNewLeader(ConfigMap configMap, LeaderInfo leaderInfo) {
        return ((ConfigMapBuilder)((ConfigMapBuilder)new ConfigMapBuilder(configMap).addToData(LEADER_PREFIX + leaderInfo.getGroupName(), leaderInfo.getLeader())).addToData(LOCAL_TIMESTAMP_PREFIX + leaderInfo.getGroupName(), ConfigMapLeaseResourceManager.formatDate(leaderInfo.getLocalTimestamp()))).build();
    }

    private static ConfigMap getConfigMapWithoutLeader(ConfigMap configMap, String group) {
        return ((ConfigMapBuilder)((ConfigMapBuilder)new ConfigMapBuilder(configMap).removeFromData(LEADER_PREFIX + group)).removeFromData(LOCAL_TIMESTAMP_PREFIX + group)).build();
    }

    private static Date getLocalTimestamp(ConfigMap configMap, String group) {
        String timestamp = ConfigMapLeaseResourceManager.getConfigMapValue(configMap, LOCAL_TIMESTAMP_PREFIX + group);
        if (timestamp == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(DATE_TIME_FORMAT).parse(timestamp);
        }
        catch (Exception e) {
            LOG.warn("Unable to parse time string '{}' using format {}", new Object[]{timestamp, DATE_TIME_FORMAT, e});
            return null;
        }
    }

    private static String getLeader(ConfigMap configMap, String group) {
        return ConfigMapLeaseResourceManager.getConfigMapValue(configMap, LEADER_PREFIX + group);
    }

    private static String getConfigMapValue(ConfigMap configMap, String key) {
        if (configMap == null || configMap.getData() == null) {
            return null;
        }
        return (String)configMap.getData().get(key);
    }

    private static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        try {
            return new SimpleDateFormat(DATE_TIME_FORMAT).format(date);
        }
        catch (Exception e) {
            LOG.warn("Unable to format date '{}' using format {}", new Object[]{date, DATE_TIME_FORMAT, e});
            return null;
        }
    }
}

