/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.config_maps;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.component.kubernetes.consumer.common.ConfigMapEvent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesConfigMapsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesConfigMapsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private ConfigMapsConsumerTask configMapWatcher;

    public KubernetesConfigMapsConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.configMapWatcher = new ConfigMapsConsumerTask();
        this.executor.submit(this.configMapWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes ConfigMap Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.configMapWatcher, this.configMapWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class ConfigMapsConsumerTask
    implements Runnable {
        private Watch watch;

        ConfigMapsConsumerTask() {
        }

        @Override
        public void run() {
            FilterWatchListDeletable w = null;
            if (ObjectHelper.isNotEmpty((String)KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((String)KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w = (FilterWatchListDeletable)KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesClient().configMaps().withLabel(KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            if (ObjectHelper.isNotEmpty((String)KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName())) {
                Resource configMapResource = (Resource)KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesClient().configMaps().withName(KubernetesConfigMapsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName());
                w = (FilterWatchListDeletable)configMapResource;
            }
            if (w == null) {
                throw new RuntimeCamelException("Consumer label key or consumer resource name need to be set.");
            }
            this.watch = w.watch((Watcher)new Watcher<ConfigMap>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived(Watcher.Action action, ConfigMap resource) {
                    ConfigMapEvent de = new ConfigMapEvent(action, resource);
                    Exchange exchange = KubernetesConfigMapsConsumer.this.createExchange(false);
                    exchange.getIn().setBody((Object)de.getConfigMap());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)de.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesConfigMapsConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesConfigMapsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                    finally {
                        KubernetesConfigMapsConsumer.this.releaseExchange(exchange, false);
                    }
                }

                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

