/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.hpa;

import io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.component.kubernetes.consumer.common.HPAEvent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesHPAConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesHPAConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private HpaConsumerTask hpasWatcher;

    public KubernetesHPAConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.hpasWatcher = new HpaConsumerTask();
        this.executor.submit(this.hpasWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes HPA Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.hpasWatcher, this.hpasWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class HpaConsumerTask
    implements Runnable {
        private Watch watch;

        HpaConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation w = KubernetesHPAConsumer.this.getEndpoint().getKubernetesClient().autoscaling().v1().horizontalPodAutoscalers();
            ObjectHelper.ifNotEmpty((Object)KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace(), arg_0 -> ((MixedOperation)w).inNamespace(arg_0));
            if (ObjectHelper.isNotEmpty((String)KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((String)KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            ObjectHelper.ifNotEmpty((Object)KubernetesHPAConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName(), arg_0 -> ((MixedOperation)w).withName(arg_0));
            this.watch = w.watch((Watcher)new Watcher<HorizontalPodAutoscaler>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived(Watcher.Action action, HorizontalPodAutoscaler resource) {
                    HPAEvent hpae = new HPAEvent(action, resource);
                    Exchange exchange = KubernetesHPAConsumer.this.createExchange(false);
                    exchange.getIn().setBody((Object)hpae.getHpa());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)hpae.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesHPAConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesHPAConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                    finally {
                        KubernetesHPAConsumer.this.releaseExchange(exchange, false);
                    }
                }

                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

