/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.services;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesServicesProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesServicesProducer.class);

    public KubernetesServicesProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listServices": {
                this.doList(exchange);
                break;
            }
            case "listServicesByLabels": {
                this.doListServiceByLabels(exchange);
                break;
            }
            case "getService": {
                this.doGetService(exchange);
                break;
            }
            case "createService": {
                this.doCreateService(exchange);
                break;
            }
            case "deleteService": {
                this.doDeleteService(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        ServiceList servicesList = null;
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        servicesList = !ObjectHelper.isEmpty((String)namespaceName) ? (ServiceList)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).list() : (ServiceList)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inAnyNamespace()).list();
        KubernetesHelper.prepareOutboundMessage(exchange, servicesList.getItems());
    }

    protected void doListServiceByLabels(Exchange exchange) {
        ServiceList servicesList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesServiceLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        servicesList = !ObjectHelper.isEmpty((String)namespaceName) ? (ServiceList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).withLabels(labels)).list() : (ServiceList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inAnyNamespace()).withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, servicesList.getItems());
    }

    protected void doGetService(Exchange exchange) {
        Service service = null;
        String serviceName = (String)exchange.getIn().getHeader("CamelKubernetesServiceName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)serviceName)) {
            LOG.error("Get a specific service require specify a service name");
            throw new IllegalArgumentException("Get a specific service require specify a service name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Get a specific service require specify a namespace name");
            throw new IllegalArgumentException("Get a specific service require specify a namespace name");
        }
        service = (Service)((ServiceResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).withName(serviceName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, service);
    }

    protected void doCreateService(Exchange exchange) {
        Service service = null;
        String serviceName = (String)exchange.getIn().getHeader("CamelKubernetesServiceName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ServiceSpec serviceSpec = (ServiceSpec)exchange.getIn().getHeader("CamelKubernetesServiceSpec", ServiceSpec.class);
        if (ObjectHelper.isEmpty((String)serviceName)) {
            LOG.error("Create a specific service require specify a service name");
            throw new IllegalArgumentException("Create a specific service require specify a service name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Create a specific service require specify a namespace name");
            throw new IllegalArgumentException("Create a specific service require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)serviceSpec)) {
            LOG.error("Create a specific service require specify a service spec bean");
            throw new IllegalArgumentException("Create a specific service require specify a service spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesServiceLabels", Map.class);
        Service serviceCreating = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(serviceName)).withLabels(labels)).endMetadata()).withSpec(serviceSpec)).build();
        service = (Service)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).create((Object)serviceCreating);
        KubernetesHelper.prepareOutboundMessage(exchange, service);
    }

    protected void doDeleteService(Exchange exchange) {
        String serviceName = (String)exchange.getIn().getHeader("CamelKubernetesServiceName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)serviceName)) {
            LOG.error("Delete a specific service require specify a service name");
            throw new IllegalArgumentException("Delete a specific service require specify a service name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Delete a specific service require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific service require specify a namespace name");
        }
        List statusDetails = ((ServiceResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).withName(serviceName)).delete();
        boolean serviceDeleted = ObjectHelper.isNotEmpty((Collection)statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, serviceDeleted);
    }
}

