/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.persistent_volumes_claims;

import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPersistentVolumesClaimsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesPersistentVolumesClaimsProducer.class);

    public KubernetesPersistentVolumesClaimsProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listPersistentVolumesClaims": {
                this.doList(exchange);
                break;
            }
            case "listPersistentVolumesClaimsByLabels": {
                this.doListPersistentVolumesClaimsByLabels(exchange);
                break;
            }
            case "getPersistentVolumeClaim": {
                this.doGetPersistentVolumeClaim(exchange);
                break;
            }
            case "createPersistentVolumeClaim": {
                this.doCreatePersistentVolumeClaim(exchange);
                break;
            }
            case "replacePersistentVolumeClaim": {
                this.doReplacePersistentVolumeClaim(exchange);
                break;
            }
            case "deletePersistentVolumeClaim": {
                this.doDeletePersistentVolumeClaim(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        PersistentVolumeClaimList persistentVolumeClaimList = (PersistentVolumeClaimList)this.getEndpoint().getKubernetesClient().persistentVolumeClaims().list();
        KubernetesHelper.prepareOutboundMessage(exchange, persistentVolumeClaimList.getItems());
    }

    protected void doListPersistentVolumesClaimsByLabels(Exchange exchange) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesPersistentVolumesClaimsLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        PersistentVolumeClaimList pvcList = !ObjectHelper.isEmpty((String)namespaceName) ? (PersistentVolumeClaimList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().persistentVolumeClaims().inNamespace(namespaceName)).withLabels(labels)).list() : (PersistentVolumeClaimList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().persistentVolumeClaims().inAnyNamespace()).withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, pvcList.getItems());
    }

    protected void doGetPersistentVolumeClaim(Exchange exchange) {
        String pvcName = (String)exchange.getIn().getHeader("CamelKubernetesPersistentVolumeClaimName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)pvcName)) {
            LOG.error("Get a specific Persistent Volume Claim require specify a Persistent Volume Claim name");
            throw new IllegalArgumentException("Get a specific Persistent Volume Claim require specify a Persistent Volume Claim name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Get a specific Persistent Volume Claim require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Persistent Volume Claim require specify a namespace name");
        }
        PersistentVolumeClaim pvc = (PersistentVolumeClaim)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().persistentVolumeClaims().inNamespace(namespaceName)).withName(pvcName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, pvc);
    }

    protected void doReplacePersistentVolumeClaim(Exchange exchange) {
        this.doCreateOrUpdatePersistentVolumeClaim(exchange, "Replace", Replaceable::replace);
    }

    protected void doCreatePersistentVolumeClaim(Exchange exchange) {
        this.doCreateOrUpdatePersistentVolumeClaim(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdatePersistentVolumeClaim(Exchange exchange, String operationName, Function<Resource<PersistentVolumeClaim>, PersistentVolumeClaim> operation) {
        String pvcName = (String)exchange.getIn().getHeader("CamelKubernetesPersistentVolumeClaimName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        PersistentVolumeClaimSpec pvcSpec = (PersistentVolumeClaimSpec)exchange.getIn().getHeader("CamelKubernetesPersistentVolumeClaimSpec", PersistentVolumeClaimSpec.class);
        if (ObjectHelper.isEmpty((String)pvcName)) {
            LOG.error("{} a specific Persistent Volume Claim require specify a Persistent Volume Claim name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific Persistent Volume Claim require specify a Persistent Volume Claim name", operationName));
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("{} a specific Persistent Volume Claim require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific Persistent Volume Claim require specify a namespace name", operationName));
        }
        if (ObjectHelper.isEmpty((Object)pvcSpec)) {
            LOG.error("{} a specific Persistent Volume Claim require specify a Persistent Volume Claim spec bean", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific Persistent Volume Claim require specify a Persistent Volume Claim spec bean", operationName));
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesPersistentVolumesClaimsLabels", Map.class);
        PersistentVolumeClaim pvcCreating = ((PersistentVolumeClaimBuilder)((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluent.MetadataNested)new PersistentVolumeClaimBuilder().withNewMetadata().withName(pvcName)).withLabels(labels)).endMetadata()).withSpec(pvcSpec)).build();
        PersistentVolumeClaim pvc = operation.apply((Resource<PersistentVolumeClaim>)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().persistentVolumeClaims().inNamespace(namespaceName)).resource((Object)pvcCreating)));
        KubernetesHelper.prepareOutboundMessage(exchange, pvc);
    }

    protected void doDeletePersistentVolumeClaim(Exchange exchange) {
        String pvcName = (String)exchange.getIn().getHeader("CamelKubernetesPersistentVolumeClaimName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)pvcName)) {
            LOG.error("Delete a specific Persistent Volume Claim require specify a Persistent Volume Claim name");
            throw new IllegalArgumentException("Delete a specific Persistent Volume Claim require specify a Persistent Volume Claim name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Delete a specific Persistent Volume Claim require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific Persistent Volume Claim require specify a namespace name");
        }
        List statusDetails = ((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().persistentVolumeClaims().inNamespace(namespaceName)).withName(pvcName)).delete();
        boolean pvcDeleted = ObjectHelper.isNotEmpty((Collection)statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, pvcDeleted);
    }
}

