/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cluster.lock.impl;

import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseBuilder;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Set;
import org.apache.camel.component.kubernetes.cluster.lock.KubernetesLeaseResourceManager;
import org.apache.camel.component.kubernetes.cluster.lock.LeaderInfo;

public class NativeLeaseResourceManager
implements KubernetesLeaseResourceManager<Lease> {
    @Override
    public LeaderInfo decodeLeaderInfo(Lease lease, Set<String> members, String group) {
        return new LeaderInfo(group, NativeLeaseResourceManager.getLeader(lease), NativeLeaseResourceManager.getLocalTimestamp(lease), members, NativeLeaseResourceManager.getLeaseDurationSeconds(lease));
    }

    @Override
    public Lease fetchLeaseResource(KubernetesClient client, String namespace, String name, String group) {
        return (Lease)((Resource)((NonNamespaceOperation)client.leases().inNamespace(namespace)).withName(NativeLeaseResourceManager.leaseResourceName(name, group))).get();
    }

    @Override
    public Lease optimisticDeleteLeaderInfo(KubernetesClient client, Lease leaseResource, String group) {
        Lease updatedLease = NativeLeaseResourceManager.getLeaseWithoutLeader(leaseResource);
        return (Lease)((Resource)((NonNamespaceOperation)client.leases().inNamespace(leaseResource.getMetadata().getNamespace())).resource((Object)updatedLease)).lockResourceVersion(leaseResource.getMetadata().getResourceVersion()).replace();
    }

    @Override
    public Lease optimisticAcquireLeadership(KubernetesClient client, Lease leaseResource, LeaderInfo newLeaderInfo) {
        Lease updatedLease = NativeLeaseResourceManager.getLeaseWithNewLeader(leaseResource, newLeaderInfo);
        return (Lease)((Resource)((NonNamespaceOperation)client.leases().inNamespace(leaseResource.getMetadata().getNamespace())).resource((Object)updatedLease)).lockResourceVersion(leaseResource.getMetadata().getResourceVersion()).replace();
    }

    @Override
    public Lease refreshLeaseRenewTime(KubernetesClient client, Lease leaseResource, int minUpdateIntervalSeconds) {
        ZonedDateTime lastRenew;
        ZonedDateTime zonedDateTime = lastRenew = leaseResource.getSpec() != null ? leaseResource.getSpec().getRenewTime() : null;
        if (lastRenew == null || lastRenew.plusSeconds(minUpdateIntervalSeconds).isBefore(ZonedDateTime.now())) {
            Lease updatedLease = ((LeaseBuilder)((LeaseFluent.SpecNested)new LeaseBuilder(leaseResource).editOrNewSpec().withRenewTime(ZonedDateTime.now())).endSpec()).build();
            return (Lease)((Resource)((NonNamespaceOperation)client.leases().inNamespace(leaseResource.getMetadata().getNamespace())).resource((Object)updatedLease)).lockResourceVersion(leaseResource.getMetadata().getResourceVersion()).replace();
        }
        return leaseResource;
    }

    @Override
    public Lease createNewLeaseResource(KubernetesClient client, String namespace, String prefix, LeaderInfo leaderInfo) {
        ZonedDateTime now = ZonedDateTime.now();
        Lease newLease = ((LeaseBuilder)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseBuilder)((LeaseFluent.MetadataNested)((LeaseFluent.MetadataNested)new LeaseBuilder().withNewMetadata().withName(NativeLeaseResourceManager.leaseResourceName(prefix, leaderInfo.getGroupName()))).addToLabels("provider", "camel")).endMetadata()).withNewSpec().withHolderIdentity(leaderInfo.getLeader())).withAcquireTime(now)).withLeaseDurationSeconds(leaderInfo.getLeaseDurationSeconds())).withRenewTime(now)).endSpec()).build();
        return (Lease)((Resource)((NonNamespaceOperation)client.leases().inNamespace(namespace)).resource((Object)newLease)).create();
    }

    private static Lease getLeaseWithNewLeader(Lease lease, LeaderInfo leaderInfo) {
        Integer transitions;
        Integer n = transitions = lease.getSpec() != null ? lease.getSpec().getLeaseTransitions() : null;
        if (transitions == null) {
            transitions = 0;
        }
        ZonedDateTime now = ZonedDateTime.now();
        return ((LeaseBuilder)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)new LeaseBuilder(lease).editOrNewSpec().withHolderIdentity(leaderInfo.getLeader())).withAcquireTime(now)).withLeaseDurationSeconds(leaderInfo.getLeaseDurationSeconds())).withRenewTime(now)).withLeaseTransitions(Integer.valueOf(transitions + 1))).endSpec()).build();
    }

    private static Lease getLeaseWithoutLeader(Lease lease) {
        return ((LeaseBuilder)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)new LeaseBuilder(lease).editOrNewSpec().withHolderIdentity(null)).withAcquireTime(null)).withRenewTime(null)).withLeaseDurationSeconds(null)).endSpec()).build();
    }

    private static Date getLocalTimestamp(Lease lease) {
        if (lease == null || lease.getSpec() == null || lease.getSpec().getAcquireTime() == null) {
            return null;
        }
        return Date.from(lease.getSpec().getAcquireTime().toInstant());
    }

    private static Integer getLeaseDurationSeconds(Lease lease) {
        if (lease == null || lease.getSpec() == null) {
            return null;
        }
        return lease.getSpec().getLeaseDurationSeconds();
    }

    private static String getLeader(Lease lease) {
        if (lease == null || lease.getSpec() == null) {
            return null;
        }
        return lease.getSpec().getHolderIdentity();
    }

    private static String leaseResourceName(String prefix, String group) {
        return NativeLeaseResourceManager.toValidKubernetesID(prefix + "-" + group);
    }

    private static String toValidKubernetesID(String id) {
        id = id.toLowerCase().replaceAll("[^a-z0-9-.]", "-");
        while (id.length() > 0 && NativeLeaseResourceManager.isNonAlphanumeric(id, 0)) {
            id = id.substring(1);
        }
        while (id.length() > 0 && NativeLeaseResourceManager.isNonAlphanumeric(id, id.length() - 1)) {
            id = id.substring(0, id.length() - 1);
        }
        return id;
    }

    private static boolean isNonAlphanumeric(String id, int pos) {
        return !Character.isAlphabetic(id.charAt(pos)) && !Character.isDigit(id.charAt(pos));
    }
}

