/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.replication_controllers;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesReplicationControllersProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesReplicationControllersProducer.class);

    public KubernetesReplicationControllersProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listReplicationControllers": {
                this.doList(exchange);
                break;
            }
            case "listReplicationControllersByLabels": {
                this.doListReplicationControllersByLabels(exchange);
                break;
            }
            case "getReplicationController": {
                this.doGetReplicationController(exchange);
                break;
            }
            case "createReplicationController": {
                this.doCreateReplicationController(exchange);
                break;
            }
            case "replaceReplicationController": {
                this.doReplaceReplicationController(exchange);
                break;
            }
            case "deleteReplicationController": {
                this.doDeleteReplicationController(exchange);
                break;
            }
            case "scaleReplicationController": {
                this.doScaleReplicationController(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ReplicationControllerList rcList = !ObjectHelper.isEmpty((String)namespaceName) ? (ReplicationControllerList)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).list() : (ReplicationControllerList)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inAnyNamespace()).list();
        KubernetesHelper.prepareOutboundMessage(exchange, rcList.getItems());
    }

    protected void doListReplicationControllersByLabels(Exchange exchange) {
        ReplicationControllerList rcList;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesReplicationControllersLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((String)namespaceName)) {
            NonNamespaceOperation replicationControllers = (NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName);
            rcList = (ReplicationControllerList)((FilterWatchListDeletable)replicationControllers.withLabels(labels)).list();
        } else {
            rcList = (ReplicationControllerList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inAnyNamespace()).withLabels(labels)).list();
        }
        KubernetesHelper.prepareOutboundMessage(exchange, rcList.getItems());
    }

    protected void doGetReplicationController(Exchange exchange) {
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)rcName)) {
            LOG.error("Get a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Get a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Get a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Get a specific replication controller require specify a namespace name");
        }
        ReplicationController rc = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).withName(rcName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, rc);
    }

    protected void doReplaceReplicationController(Exchange exchange) {
        this.doCreateOrUpdateReplicationController(exchange, "Replace", Replaceable::replace);
    }

    protected void doCreateReplicationController(Exchange exchange) {
        this.doCreateOrUpdateReplicationController(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateReplicationController(Exchange exchange, String operationName, Function<Resource<ReplicationController>, ReplicationController> operation) {
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ReplicationControllerSpec rcSpec = (ReplicationControllerSpec)exchange.getIn().getHeader("CamelKubernetesReplicationControllerSpec", ReplicationControllerSpec.class);
        if (ObjectHelper.isEmpty((String)rcName)) {
            LOG.error("{} a specific replication controller require specify a replication controller name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific replication controller require specify a replication controller name", operationName));
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("{} a specific replication controller require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific replication controller require specify a namespace name", operationName));
        }
        if (ObjectHelper.isEmpty((Object)rcSpec)) {
            LOG.error("{} a specific replication controller require specify a replication controller spec bean", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific replication controller require specify a replication controller spec bean", operationName));
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesReplicationControllersLabels", Map.class);
        ReplicationController rcCreating = ((ReplicationControllerBuilder)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName(rcName)).withLabels(labels)).endMetadata()).withSpec(rcSpec)).build();
        ReplicationController rc = operation.apply((Resource<ReplicationController>)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).resource((Object)rcCreating)));
        KubernetesHelper.prepareOutboundMessage(exchange, rc);
    }

    protected void doDeleteReplicationController(Exchange exchange) {
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)rcName)) {
            LOG.error("Delete a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Delete a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Delete a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific replication controller require specify a namespace name");
        }
        List statusDetails = ((RollableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).withName(rcName)).delete();
        boolean rcDeleted = ObjectHelper.isNotEmpty((Collection)statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, rcDeleted);
    }

    protected void doScaleReplicationController(Exchange exchange) {
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        Integer replicasNumber = (Integer)exchange.getIn().getHeader("CamelKubernetesReplicationControllerReplicas", Integer.class);
        if (ObjectHelper.isEmpty((String)rcName)) {
            LOG.error("Scale a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Scale a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Scale a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Scale a specific replication controller require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)replicasNumber)) {
            LOG.error("Scale a specific replication controller require specify a replicas number");
            throw new IllegalArgumentException("Scale a specific replication controller require specify a replicas number");
        }
        ReplicationController rcScaled = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).withName(rcName)).scale(replicasNumber.intValue(), false);
        KubernetesHelper.prepareOutboundMessage(exchange, rcScaled.getStatus().getReplicas());
    }
}

