/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.services;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesServicesProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesServicesProducer.class);

    public KubernetesServicesProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listServices": {
                this.doList(exchange);
                break;
            }
            case "listServicesByLabels": {
                this.doListServiceByLabels(exchange);
                break;
            }
            case "getService": {
                this.doGetService(exchange);
                break;
            }
            case "createService": {
                this.doCreateService(exchange);
                break;
            }
            case "updateService": {
                this.doUpdateService(exchange);
                break;
            }
            case "deleteService": {
                this.doDeleteService(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ServiceList servicesList = !ObjectHelper.isEmpty((String)namespaceName) ? (ServiceList)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).list() : (ServiceList)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inAnyNamespace()).list();
        KubernetesHelper.prepareOutboundMessage(exchange, servicesList.getItems());
    }

    protected void doListServiceByLabels(Exchange exchange) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesServiceLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ServiceList servicesList = !ObjectHelper.isEmpty((String)namespaceName) ? (ServiceList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).withLabels(labels)).list() : (ServiceList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inAnyNamespace()).withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, servicesList.getItems());
    }

    protected void doGetService(Exchange exchange) {
        String serviceName = (String)exchange.getIn().getHeader("CamelKubernetesServiceName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)serviceName)) {
            LOG.error("Get a specific service require specify a service name");
            throw new IllegalArgumentException("Get a specific service require specify a service name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Get a specific service require specify a namespace name");
            throw new IllegalArgumentException("Get a specific service require specify a namespace name");
        }
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).withName(serviceName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, service);
    }

    protected void doUpdateService(Exchange exchange) {
        this.doCreateOrUpdateService(exchange, "Update", Replaceable::update);
    }

    protected void doCreateService(Exchange exchange) {
        this.doCreateOrUpdateService(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateService(Exchange exchange, String operationName, Function<Resource<Service>, Service> operation) {
        String serviceName = (String)exchange.getIn().getHeader("CamelKubernetesServiceName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ServiceSpec serviceSpec = (ServiceSpec)exchange.getIn().getHeader("CamelKubernetesServiceSpec", ServiceSpec.class);
        if (ObjectHelper.isEmpty((String)serviceName)) {
            LOG.error("{} a specific service require specify a service name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific service require specify a service name", operationName));
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("{} a specific service require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific service require specify a namespace name", operationName));
        }
        if (ObjectHelper.isEmpty((Object)serviceSpec)) {
            LOG.error("{} a specific service require specify a service spec bean", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific service require specify a service spec bean", operationName));
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesServiceLabels", Map.class);
        Service serviceCreating = ((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(serviceName)).withLabels(labels)).endMetadata()).withSpec(serviceSpec)).build();
        Service service = operation.apply((Resource<Service>)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).resource((Object)serviceCreating)));
        KubernetesHelper.prepareOutboundMessage(exchange, service);
    }

    protected void doDeleteService(Exchange exchange) {
        String serviceName = (String)exchange.getIn().getHeader("CamelKubernetesServiceName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)serviceName)) {
            LOG.error("Delete a specific service require specify a service name");
            throw new IllegalArgumentException("Delete a specific service require specify a service name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Delete a specific service require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific service require specify a namespace name");
        }
        List statusDetails = ((ServiceResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().services().inNamespace(namespaceName)).withName(serviceName)).delete();
        boolean serviceDeleted = ObjectHelper.isNotEmpty((Collection)statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, serviceDeleted);
    }
}

