/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.resources_quota;

import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesResourcesQuotaProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesResourcesQuotaProducer.class);

    public KubernetesResourcesQuotaProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listResourcesQuota": {
                this.doList(exchange);
                break;
            }
            case "listSecretsByLabels": {
                this.doListResourceQuotasByLabels(exchange);
                break;
            }
            case "getResourceQuota": {
                this.doGetResourceQuota(exchange);
                break;
            }
            case "createResourceQuota": {
                this.doCreateResourceQuota(exchange);
                break;
            }
            case "updateResourceQuota": {
                this.doUpdateResourceQuota(exchange);
                break;
            }
            case "deleteResourceQuota": {
                this.doDeleteResourceQuota(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        ResourceQuotaList resList = (ResourceQuotaList)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inAnyNamespace()).list();
        KubernetesHelper.prepareOutboundMessage(exchange, resList.getItems());
    }

    protected void doListResourceQuotasByLabels(Exchange exchange) {
        ResourceQuotaList resList;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((String)namespaceName)) {
            NonNamespaceOperation resQuota = (NonNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inNamespace(namespaceName);
            for (Map.Entry entry : labels.entrySet()) {
                resQuota.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            resList = (ResourceQuotaList)resQuota.list();
        } else {
            MixedOperation resQuota = this.getEndpoint().getKubernetesClient().resourceQuotas();
            for (Map.Entry entry : labels.entrySet()) {
                resQuota.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            resList = (ResourceQuotaList)resQuota.list();
        }
        KubernetesHelper.prepareOutboundMessage(exchange, resList.getItems());
    }

    protected void doGetResourceQuota(Exchange exchange) {
        String rqName = (String)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)rqName)) {
            LOG.error("Get a specific Resource Quota require specify a Resource Quota name");
            throw new IllegalArgumentException("Get a specific Resource Quota require specify a Resource Quota name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Get a specific Resource Quota require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Resource Quota require specify a namespace name");
        }
        ResourceQuota rq = (ResourceQuota)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inNamespace(namespaceName)).withName(rqName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, rq);
    }

    protected void doUpdateResourceQuota(Exchange exchange) {
        this.doCreateOrUpdateResourceQuota(exchange, "Update", Replaceable::update);
    }

    protected void doCreateResourceQuota(Exchange exchange) {
        this.doCreateOrUpdateResourceQuota(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateResourceQuota(Exchange exchange, String operationName, Function<Resource<ResourceQuota>, ResourceQuota> operation) {
        String rqName = (String)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ResourceQuotaSpec rqSpec = (ResourceQuotaSpec)exchange.getIn().getHeader("CamelKubernetesResourceQuotaSpec", ResourceQuotaSpec.class);
        if (ObjectHelper.isEmpty((String)rqName)) {
            LOG.error("{} a specific resource quota require specify a resource quota name", (Object)operationName);
            throw new IllegalArgumentException(operationName + " a specific resource quota require specify a resource quota name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("{} a specific resource quota require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(operationName + " a specific resource quota require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)rqSpec)) {
            LOG.error("{} a specific resource quota require specify a resource quota spec bean", (Object)operationName);
            throw new IllegalArgumentException(operationName + " a specific resource quota require specify a resource quota spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaLabels", Map.class);
        ResourceQuota rqCreating = ((ResourceQuotaBuilder)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName(rqName)).withLabels(labels)).endMetadata()).withSpec(rqSpec)).build();
        ResourceQuota rq = operation.apply((Resource<ResourceQuota>)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inNamespace(namespaceName)).resource((Object)rqCreating)));
        KubernetesHelper.prepareOutboundMessage(exchange, rq);
    }

    protected void doDeleteResourceQuota(Exchange exchange) {
        String rqName = (String)exchange.getIn().getHeader("CamelKubernetesResourcesQuotaName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)rqName)) {
            LOG.error("Delete a specific resource quota require specify a resource quota name");
            throw new IllegalArgumentException("Delete a specific resource quota require specify a resource quota name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Delete a specific resource quota require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific resource quota require specify a namespace name");
        }
        List statusDetails = ((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().resourceQuotas().inNamespace(namespaceName)).withName(rqName)).delete();
        boolean rqDeleted = ObjectHelper.isNotEmpty((Collection)statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, rqDeleted);
    }
}

