/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.deployments;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesDeploymentsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesDeploymentsProducer.class);

    public KubernetesDeploymentsProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listDeployments": {
                this.doList(exchange);
                break;
            }
            case "listDeploymentsByLabels": {
                this.doListDeploymentsByLabels(exchange);
                break;
            }
            case "getDeployment": {
                this.doGetDeployment(exchange);
                break;
            }
            case "deleteDeployment": {
                this.doDeleteDeployment(exchange);
                break;
            }
            case "createDeployment": {
                this.doCreateDeployment(exchange);
                break;
            }
            case "updateDeployment": {
                this.doUpdateDeployment(exchange);
                break;
            }
            case "scaleDeployment": {
                this.doScaleDeployment(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        DeploymentList deploymentsList = (DeploymentList)this.getEndpoint().getKubernetesClient().apps().deployments().list();
        KubernetesHelper.prepareOutboundMessage(exchange, deploymentsList.getItems());
    }

    protected void doListDeploymentsByLabels(Exchange exchange) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesDeploymentsLabels", Map.class);
        MixedOperation deployments = this.getEndpoint().getKubernetesClient().apps().deployments();
        DeploymentList deploymentList = (DeploymentList)((FilterWatchListDeletable)deployments.withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, deploymentList.getItems());
    }

    protected void doGetDeployment(Exchange exchange) {
        String deploymentName = (String)exchange.getIn().getHeader("CamelKubernetesDeploymentName", String.class);
        if (ObjectHelper.isEmpty((String)deploymentName)) {
            LOG.error("Get a specific Deployment require specify a Deployment name");
            throw new IllegalArgumentException("Get a specific Deployment require specify a Deployment name");
        }
        Deployment deployment = (Deployment)((RollableScalableResource)this.getEndpoint().getKubernetesClient().apps().deployments().withName(deploymentName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, deployment);
    }

    protected void doDeleteDeployment(Exchange exchange) {
        String deploymentName = (String)exchange.getIn().getHeader("CamelKubernetesDeploymentName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)deploymentName)) {
            LOG.error("Delete a specific deployment require specify a deployment name");
            throw new IllegalArgumentException("Delete a specific deployment require specify a deployment name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Delete a specific deployment require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific deployment require specify a namespace name");
        }
        List statusDetails = ((RollableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().apps().deployments().inNamespace(namespaceName)).withName(deploymentName)).delete();
        boolean deploymentDeleted = ObjectHelper.isNotEmpty((Collection)statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, deploymentDeleted);
    }

    protected void doUpdateDeployment(Exchange exchange) {
        this.doCreateOrUpdateDeployment(exchange, "Update", Replaceable::update);
    }

    protected void doCreateDeployment(Exchange exchange) {
        this.doCreateOrUpdateDeployment(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateDeployment(Exchange exchange, String operationName, Function<Resource<Deployment>, Deployment> operation) {
        String deploymentName = (String)exchange.getIn().getHeader("CamelKubernetesDeploymentName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        DeploymentSpec deSpec = (DeploymentSpec)exchange.getIn().getHeader("CamelKubernetesDeploymentSpec", DeploymentSpec.class);
        if (ObjectHelper.isEmpty((String)deploymentName)) {
            LOG.error("{} a specific Deployment require specify a Deployment name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific Deployment require specify a pod name", operationName));
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("{} a specific Deployment require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific Deployment require specify a namespace name", operationName));
        }
        if (ObjectHelper.isEmpty((Object)deSpec)) {
            LOG.error("{} a specific Deployment require specify a Deployment spec bean", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific Deployment require specify a Deployment spec bean", operationName));
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesDeploymentsLabels", Map.class);
        Deployment deploymentCreating = ((DeploymentBuilder)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(deploymentName)).withLabels(labels)).endMetadata()).withSpec(deSpec)).build();
        Deployment deployment = operation.apply((Resource<Deployment>)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().apps().deployments().inNamespace(namespaceName)).resource((Object)deploymentCreating)));
        KubernetesHelper.prepareOutboundMessage(exchange, deployment);
    }

    protected void doScaleDeployment(Exchange exchange) {
        String deploymentName = (String)exchange.getIn().getHeader("CamelKubernetesDeploymentName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        Integer replicasNumber = (Integer)exchange.getIn().getHeader("CamelKubernetesDeploymentReplicas", Integer.class);
        if (ObjectHelper.isEmpty((String)deploymentName)) {
            LOG.error("Scale a specific deployment require specify a deployment name");
            throw new IllegalArgumentException("Scale a specific deployment require specify a deployment name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Scale a specific deployment require specify a namespace name");
            throw new IllegalArgumentException("Scale a specific deployment require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)replicasNumber)) {
            LOG.error("Scale a specific deployment require specify a replicas number");
            throw new IllegalArgumentException("Scale a specific deployment require specify a replicas number");
        }
        Deployment deploymentScaled = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().apps().deployments().inNamespace(namespaceName)).withName(deploymentName)).scale(replicasNumber.intValue(), false);
        KubernetesHelper.prepareOutboundMessage(exchange, deploymentScaled.getStatus().getReplicas());
    }
}

