/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.events;

import io.fabric8.kubernetes.api.model.MicroTimeBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.events.v1.Event;
import io.fabric8.kubernetes.api.model.events.v1.EventBuilder;
import io.fabric8.kubernetes.api.model.events.v1.EventFluent;
import io.fabric8.kubernetes.api.model.events.v1.EventList;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesEventsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesEventsProducer.class);

    public KubernetesEventsProducer(AbstractKubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listEvents": {
                this.doList(exchange);
                break;
            }
            case "listEventsByLabels": {
                this.doListEventsByLabel(exchange);
                break;
            }
            case "getEvent": {
                this.doGetEvent(exchange);
                break;
            }
            case "createEvent": {
                this.doCreateEvent(exchange);
                break;
            }
            case "updateEvent": {
                this.doUpdateEvent(exchange);
                break;
            }
            case "deleteEvent": {
                this.doDeleteEvent(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        EventList eventList = ObjectHelper.isNotEmpty((String)namespaceName) ? (EventList)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().events().v1().events().inNamespace(namespaceName)).list() : (EventList)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().events().v1().events().inAnyNamespace()).list();
        KubernetesHelper.prepareOutboundMessage(exchange, eventList.getItems());
    }

    protected void doListEventsByLabel(Exchange exchange) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesEventsLabels", Map.class);
        if (ObjectHelper.isEmpty((Map)labels)) {
            LOG.error("Get events by labels require specify a labels set");
            throw new IllegalArgumentException("Get events by labels require specify a labels set");
        }
        EventList eventList = (EventList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().events().v1().events().inAnyNamespace()).withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, eventList.getItems());
    }

    protected void doGetEvent(Exchange exchange) {
        String eventName = (String)exchange.getIn().getHeader("CamelKubernetesEventName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)eventName)) {
            LOG.error("Get a specific event require specify a event name");
            throw new IllegalArgumentException("Get a specific event require specify a event name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Get a specific event require specify a namespace name");
            throw new IllegalArgumentException("Get a specific event require specify a namespace name");
        }
        Event event = (Event)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().events().v1().events().inNamespace(namespaceName)).withName(eventName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, event);
    }

    protected void doUpdateEvent(Exchange exchange) {
        this.doCreateOrUpdateEvent(exchange, "Update", Replaceable::update);
    }

    protected void doCreateEvent(Exchange exchange) {
        this.doCreateOrUpdateEvent(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateEvent(Exchange exchange, String operationName, Function<Resource<Event>, Event> operation) {
        String eventName = (String)exchange.getIn().getHeader("CamelKubernetesEventName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)eventName)) {
            LOG.error("{} a specific event require specify a event name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific event require specify a event name", operationName));
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("{} a specific event require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific event require specify a namespace name", operationName));
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesEventsLabels", Map.class);
        EventBuilder builder = (EventBuilder)exchange.getIn().getBody(EventBuilder.class);
        if (builder == null) {
            builder = (EventBuilder)((EventBuilder)((EventBuilder)((EventBuilder)((EventBuilder)((EventBuilder)((EventBuilder)((EventBuilder)((EventBuilder)new EventBuilder().withEventTime(((MicroTimeBuilder)new MicroTimeBuilder().withTime((String)exchange.getIn().getHeader("CamelKubernetesEventTime", () -> OffsetDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME), String.class))).build())).withAction((String)exchange.getIn().getHeader("CamelKubernetesEventAction", String.class))).withType((String)exchange.getIn().getHeader("CamelKubernetesEventType", String.class))).withReason((String)exchange.getIn().getHeader("CamelKubernetesEventReason", String.class))).withNote((String)exchange.getIn().getHeader("CamelKubernetesEventNote", String.class))).withReportingController((String)exchange.getIn().getHeader("CamelKubernetesEventReportingController", String.class))).withReportingInstance((String)exchange.getIn().getHeader("CamelKubernetesEventReportingInstance", String.class))).withRegarding((ObjectReference)exchange.getIn().getHeader("CamelKubernetesEventRegarding", ObjectReference.class))).withRelated((ObjectReference)exchange.getIn().getHeader("CamelKubernetesEventRelated", ObjectReference.class));
        }
        Event eventCreating = ((EventBuilder)((EventFluent.MetadataNested)((EventFluent.MetadataNested)builder.withNewMetadata().withName(eventName)).withLabels(labels)).endMetadata()).build();
        Event event = operation.apply((Resource<Event>)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().events().v1().events().inNamespace(namespaceName)).resource((Object)eventCreating)));
        KubernetesHelper.prepareOutboundMessage(exchange, event);
    }

    protected void doDeleteEvent(Exchange exchange) {
        String eventName = (String)exchange.getIn().getHeader("CamelKubernetesEventName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((String)eventName)) {
            LOG.error("Delete a specific event require specify a event name");
            throw new IllegalArgumentException("Delete a specific event require specify a event name");
        }
        if (ObjectHelper.isEmpty((String)namespaceName)) {
            LOG.error("Delete a specific event require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific event require specify a namespace name");
        }
        List statusDetails = ((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().events().v1().events().inNamespace(namespaceName)).withName(eventName)).delete();
        boolean eventDeleted = ObjectHelper.isNotEmpty((Collection)statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, eventDeleted);
    }
}

