/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.properties;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import org.apache.camel.component.kubernetes.properties.BasePropertiesFunction;

abstract class BaseConfigMapPropertiesFunction
extends BasePropertiesFunction {
    BaseConfigMapPropertiesFunction() {
    }

    @Override
    Path getMountPath() {
        if (this.getMountPathConfigMaps() != null) {
            return Paths.get(this.getMountPathConfigMaps(), new String[0]);
        }
        return null;
    }

    @Override
    String lookup(String name, String key, String defaultValue) {
        String answer = null;
        ConfigMap cm = (ConfigMap)((Resource)this.getClient().configMaps().withName(name)).get();
        if (cm != null) {
            String string = answer = cm.getData() != null ? (String)cm.getData().get(key) : null;
            if (answer == null) {
                byte[] data;
                String string2 = answer = cm.getBinaryData() != null ? (String)cm.getBinaryData().get(key) : null;
                if (answer != null && (data = Base64.getDecoder().decode(answer)) != null) {
                    answer = this.handleData(key, data);
                }
            }
        }
        if (answer == null) {
            return defaultValue;
        }
        return answer;
    }
}

